!/**
 * Highcharts JS v11.4.0 (2024-03-04)
 *
 * Standalone navigator module
 *
 * (c) 2009-2024 Mateusz Bernacik
 *
 * License: www.highcharts.com/license
 */function(t){"object"==typeof module&&module.exports?(t.default=t,module.exports=t):"function"==typeof define&&define.amd?define("highcharts/modules/navigator",["highcharts"],function(i){return t(i),t.Highcharts=i,t}):t("undefined"!=typeof Highcharts?Highcharts:void 0)}(function(t){"use strict";var i=t?t._modules:{};function e(t,i,e,s){t.hasOwnProperty(i)||(t[i]=s.apply(null,e),"function"==typeof CustomEvent&&window.dispatchEvent(new CustomEvent("HighchartsModuleLoaded",{detail:{path:i,module:t[i]}})))}e(i,"Stock/Navigator/ChartNavigatorComposition.js",[i["Core/Globals.js"],i["Core/Utilities.js"]],function(t,i){var e,s=t.isTouchDevice,o=i.addEvent,r=i.merge,a=i.pick,n=[];function h(){this.navigator&&this.navigator.setBaseSeries(null,!1)}function d(){var t,i,e,s,o=this.legend,r=this.navigator;if(r){i=o&&o.options,e=r.xAxis,s=r.yAxis;var n=r.scrollbarHeight,h=r.scrollButtonSize;this.inverted?(r.left=r.opposite?this.chartWidth-n-r.height:this.spacing[3]+n,r.top=this.plotTop+h):(r.left=a(e.left,this.plotLeft+h),r.top=r.navigatorOptions.top||this.chartHeight-r.height-n-((null===(t=this.scrollbar)||void 0===t?void 0:t.options.margin)||0)-this.spacing[2]-(this.rangeSelector&&this.extraBottomMargin?this.rangeSelector.getHeight():0)-(i&&"bottom"===i.verticalAlign&&"proximate"!==i.layout&&i.enabled&&!i.floating?o.legendHeight+a(i.margin,10):0)-(this.titleOffset?this.titleOffset[2]:0)),e&&s&&(this.inverted?e.options.left=s.options.left=r.left:e.options.top=s.options.top=r.top,e.setAxisSize(),s.setAxisSize())}}function l(t){!this.navigator&&!this.scroller&&(this.options.navigator.enabled||this.options.scrollbar.enabled)&&(this.scroller=this.navigator=new e(this),a(t.redraw,!0)&&this.redraw(t.animation))}function c(){var t=this.options;(t.navigator.enabled||t.scrollbar.enabled)&&(this.scroller=this.navigator=new e(this))}function g(){var t=this.options,i=t.navigator,e=t.rangeSelector;if((i&&i.enabled||e&&e.enabled)&&(!s&&"x"===this.zooming.type||s&&"x"===this.zooming.pinchType))return!1}function p(t){var i=t.navigator;if(i&&t.xAxis[0]){var e=t.xAxis[0].getExtremes();i.render(e.min,e.max)}}function u(t){var i=t.options.navigator||{},e=t.options.scrollbar||{};!this.navigator&&!this.scroller&&(i.enabled||e.enabled)&&(r(!0,this.options.navigator,i),r(!0,this.options.scrollbar,e),delete t.options.navigator,delete t.options.scrollbar)}return{compose:function(t,s){if(i.pushUnique(n,t)){var r=t.prototype;e=s,r.callbacks.push(p),o(t,"afterAddSeries",h),o(t,"afterSetChartSize",d),o(t,"afterUpdate",l),o(t,"beforeRender",c),o(t,"beforeShowResetZoom",g),o(t,"update",u)}}}}),e(i,"Core/Axis/NavigatorAxisComposition.js",[i["Core/Globals.js"],i["Core/Utilities.js"]],function(t,i){var e=t.isTouchDevice,s=i.addEvent,o=i.correctFloat,r=i.defined,a=i.isNumber,n=i.pick;function h(){this.navigatorAxis||(this.navigatorAxis=new l(this))}function d(t){var i,s=this.chart,o=s.options,a=o.navigator,n=this.navigatorAxis,h=s.zooming.pinchType,d=o.rangeSelector,l=s.zooming.type;if(this.isXAxis&&((null==a?void 0:a.enabled)||(null==d?void 0:d.enabled))){if("y"===l&&"zoom"===t.trigger)i=!1;else if(("zoom"===t.trigger&&"xy"===l||e&&"xy"===h)&&this.options.range){var c=n.previousZoom;r(t.min)?n.previousZoom=[this.min,this.max]:c&&(t.min=c[0],t.max=c[1],n.previousZoom=void 0)}}void 0!==i&&t.preventDefault()}var l=function(){function t(t){this.axis=t}return t.compose=function(t){t.keepProps.includes("navigatorAxis")||(t.keepProps.push("navigatorAxis"),s(t,"init",h),s(t,"setExtremes",d))},t.prototype.destroy=function(){this.axis=void 0},t.prototype.toFixedRange=function(t,i,e,s){var h,d=this.axis,l=d.chart,c=n(null===(h=d.ordinal)||void 0===h?void 0:h.convertOverscroll(d.options.overscroll),0),g=n(e,d.translate(t,!0,!d.horiz)),p=n(s,d.translate(i,!0,!d.horiz)),u=l&&l.fixedRange,v=(d.pointRange||0)/2;if(r(e)||(g=o(g+v)),r(s)||(p=o(p-v)),u&&d.dataMin&&d.dataMax){var x=d.dataMax+c;p>=x&&(g=o(x-u),p=o(x)),g<=d.dataMin&&(p=o(d.dataMin+u))}return a(g)&&a(p)||(g=p=void 0),{min:g,max:p}},t}();return l}),e(i,"Stock/Navigator/NavigatorDefaults.js",[i["Core/Color/Color.js"],i["Core/Series/SeriesRegistry.js"]],function(t,i){var e=t.parse,s=i.seriesTypes;return{height:40,margin:25,maskInside:!0,handles:{width:7,height:15,symbols:["navigator-handle","navigator-handle"],enabled:!0,lineWidth:1,backgroundColor:"#f2f2f2",borderColor:"#999999"},maskFill:e("#667aff").setOpacity(.3).get(),outlineColor:"#999999",outlineWidth:1,series:{type:void 0===s.areaspline?"line":"areaspline",fillOpacity:.05,lineWidth:1,compare:null,sonification:{enabled:!1},dataGrouping:{approximation:"average",enabled:!0,groupPixelWidth:2,firstAnchor:"firstPoint",anchor:"middle",lastAnchor:"lastPoint",units:[["millisecond",[1,2,5,10,20,25,50,100,200,500]],["second",[1,2,5,10,15,30]],["minute",[1,2,5,10,15,30]],["hour",[1,2,3,4,6,8,12]],["day",[1,2,3,4]],["week",[1,2,3]],["month",[1,3,6]],["year",null]]},dataLabels:{enabled:!1,zIndex:2},id:"highcharts-navigator-series",className:"highcharts-navigator-series",lineColor:null,marker:{enabled:!1},threshold:null},xAxis:{className:"highcharts-navigator-xaxis",tickLength:0,lineWidth:0,gridLineColor:"#e6e6e6",gridLineWidth:1,tickPixelInterval:200,labels:{align:"left",style:{color:"#000000",fontSize:"0.7em",opacity:.6,textOutline:"2px contrast"},x:3,y:-4},crosshair:!1},yAxis:{className:"highcharts-navigator-yaxis",gridLineWidth:0,startOnTick:!1,endOnTick:!1,minPadding:.1,maxPadding:.1,labels:{enabled:!1},crosshair:!1,title:{text:null},tickLength:0,tickWidth:0}}}),e(i,"Stock/Navigator/NavigatorSymbols.js",[],function(){return{"navigator-handle":function(t,i,e,s,o){void 0===o&&(o={});var r=o.width?o.width/2:e,a=Math.round(r/3)+.5;return[["M",-r-1,.5],["L",r,.5],["L",r,(s=o.height||s)+.5],["L",-r-1,s+.5],["L",-r-1,.5],["M",-a,4],["L",-a,s-3],["M",a-1,4],["L",a-1,s-3]]}}}),e(i,"Stock/Utilities/StockUtilities.js",[i["Core/Utilities.js"]],function(t){var i=t.defined;return{setFixedRange:function(t){var e=this.xAxis[0];i(e.dataMax)&&i(e.dataMin)&&t?this.fixedRange=Math.min(t,e.dataMax-e.dataMin):this.fixedRange=t}}}),e(i,"Stock/Navigator/NavigatorComposition.js",[i["Core/Defaults.js"],i["Core/Globals.js"],i["Core/Axis/NavigatorAxisComposition.js"],i["Stock/Navigator/NavigatorDefaults.js"],i["Stock/Navigator/NavigatorSymbols.js"],i["Core/Renderer/RendererRegistry.js"],i["Stock/Utilities/StockUtilities.js"],i["Core/Utilities.js"]],function(t,i,e,s,o,r,a,n){var h=t.setOptions,d=i.composed,l=r.getRendererType,c=a.setFixedRange,g=n.addEvent,p=n.extend,u=n.pushUnique;function v(){this.chart.navigator&&!this.options.isInternal&&this.chart.navigator.setBaseSeries(null,!1)}return{compose:function(t,i,r){e.compose(i),u(d,"Navigator")&&(t.prototype.setFixedRange=c,p(l().prototype.symbols,o),g(r,"afterUpdate",v),h({navigator:s}))}}}),e(i,"Core/Axis/ScrollbarAxis.js",[i["Core/Globals.js"],i["Core/Utilities.js"]],function(t,i){var e,s=t.composed,o=i.addEvent,r=i.defined,a=i.pick,n=i.pushUnique;return function(t){var i;function e(t){var i=a(t.options&&t.options.min,t.min),e=a(t.options&&t.options.max,t.max);return{axisMin:i,axisMax:e,scrollMin:r(t.dataMin)?Math.min(i,t.min,t.dataMin,a(t.threshold,1/0)):i,scrollMax:r(t.dataMax)?Math.max(e,t.max,t.dataMax,a(t.threshold,-1/0)):e}}function h(){var t=this.scrollbar,i=t&&!t.options.opposite,e=this.horiz?2:i?3:1;t&&(this.chart.scrollbarsOffsets=[0,0],this.chart.axisOffset[e]+=t.size+(t.options.margin||0))}function d(){var t=this;t.options&&t.options.scrollbar&&t.options.scrollbar.enabled&&(t.options.scrollbar.vertical=!t.horiz,t.options.startOnTick=t.options.endOnTick=!1,t.scrollbar=new i(t.chart.renderer,t.options.scrollbar,t.chart),o(t.scrollbar,"changed",function(i){var s,o,a=e(t),n=a.axisMin,h=a.axisMax,d=a.scrollMin,l=a.scrollMax-d;if(r(n)&&r(h)){if(t.horiz&&!t.reversed||!t.horiz&&t.reversed?(s=d+l*this.to,o=d+l*this.from):(s=d+l*(1-this.from),o=d+l*(1-this.to)),this.shouldUpdateExtremes(i.DOMType)){var c="mousemove"!==i.DOMType&&"touchmove"!==i.DOMType&&void 0;t.setExtremes(o,s,!0,c,i)}else this.setRange(this.from,this.to)}}))}function l(){var t,i,s,o=e(this),a=o.scrollMin,n=o.scrollMax,h=this.scrollbar,d=this.axisTitleMargin+(this.titleOffset||0),l=this.chart.scrollbarsOffsets,c=this.options.margin||0;if(h&&l){if(this.horiz)this.opposite||(l[1]+=d),h.position(this.left,this.top+this.height+2+l[1]-(this.opposite?c:0),this.width,this.height),this.opposite||(l[1]+=c),t=1;else{this.opposite&&(l[0]+=d);var g=void 0;g=h.options.opposite?this.left+this.width+2+l[0]-(this.opposite?0:c):this.opposite?0:c,h.position(g,this.top,this.width,this.height),this.opposite&&(l[0]+=c),t=0}l[t]+=h.size+(h.options.margin||0),isNaN(a)||isNaN(n)||!r(this.min)||!r(this.max)||this.min===this.max?h.setRange(0,1):(i=(this.min-a)/(n-a),s=(this.max-a)/(n-a),this.horiz&&!this.reversed||!this.horiz&&this.reversed?h.setRange(i,s):h.setRange(1-s,1-i))}}t.compose=function(t,e){n(s,"Axis.Scrollbar")&&(i=e,o(t,"afterGetOffset",h),o(t,"afterInit",d),o(t,"afterRender",l))}}(e||(e={})),e}),e(i,"Stock/Scrollbar/ScrollbarDefaults.js",[],function(){return{height:10,barBorderRadius:5,buttonBorderRadius:0,buttonsEnabled:!1,liveRedraw:void 0,margin:void 0,minWidth:6,opposite:!0,step:.2,zIndex:3,barBackgroundColor:"#cccccc",barBorderWidth:0,barBorderColor:"#cccccc",buttonArrowColor:"#333333",buttonBackgroundColor:"#e6e6e6",buttonBorderColor:"#cccccc",buttonBorderWidth:1,rifleColor:"none",trackBackgroundColor:"rgba(255, 255, 255, 0.001)",trackBorderColor:"#cccccc",trackBorderRadius:5,trackBorderWidth:1}}),e(i,"Stock/Scrollbar/Scrollbar.js",[i["Core/Defaults.js"],i["Core/Globals.js"],i["Core/Axis/ScrollbarAxis.js"],i["Stock/Scrollbar/ScrollbarDefaults.js"],i["Core/Utilities.js"]],function(t,i,e,s,o){var r=t.defaultOptions,a=o.addEvent,n=o.correctFloat,h=o.defined,d=o.destroyObjectProperties,l=o.fireEvent,c=o.merge,g=o.pick,p=o.removeEvent,u=function(){function t(t,i,e){this._events=[],this.chartX=0,this.chartY=0,this.from=0,this.scrollbarButtons=[],this.scrollbarLeft=0,this.scrollbarStrokeWidth=1,this.scrollbarTop=0,this.size=0,this.to=0,this.trackBorderWidth=1,this.x=0,this.y=0,this.init(t,i,e)}return t.compose=function(i){e.compose(i,t)},t.swapXY=function(t,i){return i&&t.forEach(function(t){for(var i,e=t.length,s=0;s<e;s+=2)"number"==typeof(i=t[s+1])&&(t[s+1]=t[s+2],t[s+2]=i)}),t},t.prototype.addEvents=function(){var t=this.options.inverted?[1,0]:[0,1],i=this.scrollbarButtons,e=this.scrollbarGroup.element,s=this.track.element,o=this.mouseDownHandler.bind(this),r=this.mouseMoveHandler.bind(this),n=this.mouseUpHandler.bind(this),h=[[i[t[0]].element,"click",this.buttonToMinClick.bind(this)],[i[t[1]].element,"click",this.buttonToMaxClick.bind(this)],[s,"click",this.trackClick.bind(this)],[e,"mousedown",o],[e.ownerDocument,"mousemove",r],[e.ownerDocument,"mouseup",n],[e,"touchstart",o],[e.ownerDocument,"touchmove",r],[e.ownerDocument,"touchend",n]];h.forEach(function(t){a.apply(null,t)}),this._events=h},t.prototype.buttonToMaxClick=function(t){var i=(this.to-this.from)*g(this.options.step,.2);this.updatePosition(this.from+i,this.to+i),l(this,"changed",{from:this.from,to:this.to,trigger:"scrollbar",DOMEvent:t})},t.prototype.buttonToMinClick=function(t){var i=n(this.to-this.from)*g(this.options.step,.2);this.updatePosition(n(this.from-i),n(this.to-i)),l(this,"changed",{from:this.from,to:this.to,trigger:"scrollbar",DOMEvent:t})},t.prototype.cursorToScrollbarPosition=function(t){var i=this.options,e=i.minWidth>this.calculatedWidth?i.minWidth:0;return{chartX:(t.chartX-this.x-this.xOffset)/(this.barWidth-e),chartY:(t.chartY-this.y-this.yOffset)/(this.barWidth-e)}},t.prototype.destroy=function(){var t=this,i=t.chart.scroller;t.removeEvents(),["track","scrollbarRifles","scrollbar","scrollbarGroup","group"].forEach(function(i){t[i]&&t[i].destroy&&(t[i]=t[i].destroy())}),i&&t===i.scrollbar&&(i.scrollbar=null,d(i.scrollbarButtons))},t.prototype.drawScrollbarButton=function(i){var e=this.renderer,s=this.scrollbarButtons,o=this.options,r=this.size,a=e.g().add(this.group);if(s.push(a),o.buttonsEnabled){var n=e.rect().addClass("highcharts-scrollbar-button").add(a);this.chart.styledMode||n.attr({stroke:o.buttonBorderColor,"stroke-width":o.buttonBorderWidth,fill:o.buttonBackgroundColor}),n.attr(n.crisp({x:-.5,y:-.5,width:r+1,height:r+1,r:o.buttonBorderRadius},n.strokeWidth()));var h=e.path(t.swapXY([["M",r/2+(i?-1:1),r/2-3],["L",r/2+(i?-1:1),r/2+3],["L",r/2+(i?2:-2),r/2]],o.vertical)).addClass("highcharts-scrollbar-arrow").add(s[i]);this.chart.styledMode||h.attr({fill:o.buttonArrowColor})}},t.prototype.init=function(t,i,e){this.scrollbarButtons=[],this.renderer=t,this.userOptions=i,this.options=c(s,r.scrollbar,i),this.options.margin=g(this.options.margin,10),this.chart=e,this.size=g(this.options.size,this.options.height),i.enabled&&(this.render(),this.addEvents())},t.prototype.mouseDownHandler=function(t){var i,e=(null===(i=this.chart.pointer)||void 0===i?void 0:i.normalize(t))||t,s=this.cursorToScrollbarPosition(e);this.chartX=s.chartX,this.chartY=s.chartY,this.initPositions=[this.from,this.to],this.grabbedCenter=!0},t.prototype.mouseMoveHandler=function(t){var i,e,s=(null===(i=this.chart.pointer)||void 0===i?void 0:i.normalize(t))||t,o=this.options.vertical?"chartY":"chartX",r=this.initPositions||[];this.grabbedCenter&&(!t.touches||0!==t.touches[0][o])&&(e=this.cursorToScrollbarPosition(s)[o]-this[o],this.hasDragged=!0,this.updatePosition(r[0]+e,r[1]+e),this.hasDragged&&l(this,"changed",{from:this.from,to:this.to,trigger:"scrollbar",DOMType:t.type,DOMEvent:t}))},t.prototype.mouseUpHandler=function(t){this.hasDragged&&l(this,"changed",{from:this.from,to:this.to,trigger:"scrollbar",DOMType:t.type,DOMEvent:t}),this.grabbedCenter=this.hasDragged=this.chartX=this.chartY=null},t.prototype.position=function(t,i,e,s){var o=this.options,r=o.buttonsEnabled,a=o.margin,n=void 0===a?0:a,h=o.vertical,d=this.rendered?"animate":"attr",l=s,c=0;this.group.show(),this.x=t,this.y=i+this.trackBorderWidth,this.width=e,this.height=s,this.xOffset=l,this.yOffset=c,h?(this.width=this.yOffset=e=c=this.size,this.xOffset=l=0,this.yOffset=c=r?this.size:0,this.barWidth=s-(r?2*e:0),this.x=t+=n):(this.height=s=this.size,this.xOffset=l=r?this.size:0,this.barWidth=e-(r?2*s:0),this.y=this.y+n),this.group[d]({translateX:t,translateY:this.y}),this.track[d]({width:e,height:s}),this.scrollbarButtons[1][d]({translateX:h?0:e-l,translateY:h?s-c:0})},t.prototype.removeEvents=function(){this._events.forEach(function(t){p.apply(null,t)}),this._events.length=0},t.prototype.render=function(){var i=this.renderer,e=this.options,s=this.size,o=this.chart.styledMode,r=i.g("scrollbar").attr({zIndex:e.zIndex}).hide().add();this.group=r,this.track=i.rect().addClass("highcharts-scrollbar-track").attr({r:e.trackBorderRadius||0,height:s,width:s}).add(r),o||this.track.attr({fill:e.trackBackgroundColor,stroke:e.trackBorderColor,"stroke-width":e.trackBorderWidth});var a=this.trackBorderWidth=this.track.strokeWidth();this.track.attr({x:-a%2/2,y:-a%2/2}),this.scrollbarGroup=i.g().add(r),this.scrollbar=i.rect().addClass("highcharts-scrollbar-thumb").attr({height:s-a,width:s-a,r:e.barBorderRadius||0}).add(this.scrollbarGroup),this.scrollbarRifles=i.path(t.swapXY([["M",-3,s/4],["L",-3,2*s/3],["M",0,s/4],["L",0,2*s/3],["M",3,s/4],["L",3,2*s/3]],e.vertical)).addClass("highcharts-scrollbar-rifles").add(this.scrollbarGroup),o||(this.scrollbar.attr({fill:e.barBackgroundColor,stroke:e.barBorderColor,"stroke-width":e.barBorderWidth}),this.scrollbarRifles.attr({stroke:e.rifleColor,"stroke-width":1})),this.scrollbarStrokeWidth=this.scrollbar.strokeWidth(),this.scrollbarGroup.translate(-this.scrollbarStrokeWidth%2/2,-this.scrollbarStrokeWidth%2/2),this.drawScrollbarButton(0),this.drawScrollbarButton(1)},t.prototype.setRange=function(t,i){var e,s,o=this.options,r=o.vertical,a=o.minWidth,d=this.barWidth,l=!this.rendered||this.hasDragged||this.chart.navigator&&this.chart.navigator.hasDragged?"attr":"animate";if(h(d)){var c=d*Math.min(i,1);e=Math.ceil(d*(t=Math.max(t,0))),this.calculatedWidth=s=n(c-e),s<a&&(e=(d-a+s)*t,s=a);var g=Math.floor(e+this.xOffset+this.yOffset),p=s/2-.5;this.from=t,this.to=i,r?(this.scrollbarGroup[l]({translateY:g}),this.scrollbar[l]({height:s}),this.scrollbarRifles[l]({translateY:p}),this.scrollbarTop=g,this.scrollbarLeft=0):(this.scrollbarGroup[l]({translateX:g}),this.scrollbar[l]({width:s}),this.scrollbarRifles[l]({translateX:p}),this.scrollbarLeft=g,this.scrollbarTop=0),s<=12?this.scrollbarRifles.hide():this.scrollbarRifles.show(),!1===o.showFull&&(t<=0&&i>=1?this.group.hide():this.group.show()),this.rendered=!0}},t.prototype.shouldUpdateExtremes=function(t){return g(this.options.liveRedraw,i.svg&&!i.isTouchDevice&&!this.chart.boosted)||"mouseup"===t||"touchend"===t||!h(t)},t.prototype.trackClick=function(t){var i,e=(null===(i=this.chart.pointer)||void 0===i?void 0:i.normalize(t))||t,s=this.to-this.from,o=this.y+this.scrollbarTop,r=this.x+this.scrollbarLeft;this.options.vertical&&e.chartY>o||!this.options.vertical&&e.chartX>r?this.updatePosition(this.from+s,this.to+s):this.updatePosition(this.from-s,this.to-s),l(this,"changed",{from:this.from,to:this.to,trigger:"scrollbar",DOMEvent:t})},t.prototype.update=function(t){this.destroy(),this.init(this.chart.renderer,c(!0,this.options,t),this.chart)},t.prototype.updatePosition=function(t,i){i>1&&(t=n(1-n(i-t)),i=1),t<0&&(i=n(i-t),t=0),this.from=t,this.to=i},t.defaultOptions=s,t}();return r.scrollbar=c(!0,u.defaultOptions,r.scrollbar),u}),e(i,"Stock/Navigator/Navigator.js",[i["Core/Axis/Axis.js"],i["Stock/Navigator/ChartNavigatorComposition.js"],i["Core/Defaults.js"],i["Core/Globals.js"],i["Core/Axis/NavigatorAxisComposition.js"],i["Stock/Navigator/NavigatorComposition.js"],i["Stock/Scrollbar/Scrollbar.js"],i["Core/Utilities.js"]],function(t,i,e,s,o,r,a,n){var h=e.defaultOptions,d=s.isTouchDevice,l=n.addEvent,c=n.clamp,g=n.correctFloat,p=n.defined,u=n.destroyObjectProperties,v=n.erase,x=n.extend,f=n.find,m=n.fireEvent,b=n.isArray,M=n.isNumber,y=n.merge,A=n.pick,k=n.removeEvent,S=n.splat;function E(t){for(var i=[],e=1;e<arguments.length;e++)i[e-1]=arguments[e];var s=[].filter.call(i,M);if(s.length)return Math[t].apply(0,s)}return function(){function e(t){this.scrollbarHeight=0,this.init(t)}return e.compose=function(t,s,o){i.compose(t,e),r.compose(t,s,o)},e.prototype.drawHandle=function(t,i,e,s){var o=this.navigatorOptions.handles.height;this.handles[i][s](e?{translateX:Math.round(this.left+this.height/2),translateY:Math.round(this.top+parseInt(t,10)+.5-o)}:{translateX:Math.round(this.left+parseInt(t,10)),translateY:Math.round(this.top+this.height/2-o/2-1)})},e.prototype.drawOutline=function(t,i,e,s){var o,r,a=this.navigatorOptions.maskInside,n=this.outline.strokeWidth(),h=n/2,d=n%2/2,l=this.scrollButtonSize,c=this.size,g=this.top,p=this.height,u=g-h,v=g+p,x=this.left;e?(o=g+i+d,i=g+t+d,r=[["M",x+p,g-l-d],["L",x+p,o],["L",x,o],["M",x,i],["L",x+p,i],["L",x+p,g+c+l]],a&&r.push(["M",x+p,o-h],["L",x+p,i+h])):(x-=l,t+=x+l-d,i+=x+l-d,r=[["M",x,u],["L",t,u],["L",t,v],["M",i,v],["L",i,u],["L",x+c+2*l,g+h]],a&&r.push(["M",t-h,u],["L",i+h,u])),this.outline[s]({d:r})},e.prototype.drawMasks=function(t,i,e,s){var o,r,a,n,h=this.left,d=this.top,l=this.height;e?(a=[h,h,h],n=[d,d+t,d+i],r=[l,l,l],o=[t,i-t,this.size-i]):(a=[h,h+t,h+i],n=[d,d,d],r=[t,i-t,this.size-i],o=[l,l,l]),this.shades.forEach(function(t,i){t[s]({x:a[i],y:n[i],width:r[i],height:o[i]})})},e.prototype.renderElements=function(){var t=this,i=t.navigatorOptions,e=i.maskInside,s=t.chart,o=s.inverted,r=s.renderer,a={cursor:o?"ns-resize":"ew-resize"},n=t.navigatorGroup=r.g("navigator").attr({zIndex:8,visibility:"hidden"}).add();if([!e,e,!e].forEach(function(e,o){var h=r.rect().addClass("highcharts-navigator-mask"+(1===o?"-inside":"-outside")).add(n);s.styledMode||(h.attr({fill:e?i.maskFill:"rgba(0,0,0,0)"}),1===o&&h.css(a)),t.shades[o]=h}),t.outline=r.path().addClass("highcharts-navigator-outline").add(n),s.styledMode||t.outline.attr({"stroke-width":i.outlineWidth,stroke:i.outlineColor}),i.handles&&i.handles.enabled){var h=i.handles,d=h.height,l=h.width;[0,1].forEach(function(i){t.handles[i]=r.symbol(h.symbols[i],-l/2-1,0,l,d,h),s.inverted&&t.handles[i].attr({rotation:90,rotationOriginX:Math.floor(-l/2),rotationOriginY:(d+l)/2}),t.handles[i].attr({zIndex:7-i}).addClass("highcharts-navigator-handle highcharts-navigator-handle-"+["left","right"][i]).add(n),s.styledMode||t.handles[i].attr({fill:h.backgroundColor,stroke:h.borderColor,"stroke-width":h.lineWidth}).css(a)})}},e.prototype.update=function(t){(this.series||[]).forEach(function(t){t.baseSeries&&delete t.baseSeries.navigatorSeries}),this.destroy(),y(!0,this.chart.options.navigator,t),this.init(this.chart)},e.prototype.render=function(t,i,e,s){var o,r,a,n,h,d=this.chart,l=this.xAxis,u=l.pointRange||0,v=l.navigatorAxis.fake?d.xAxis[0]:l,x=this.navigatorEnabled,f=this.rendered,b=d.inverted,y=d.xAxis[0].minRange,k=d.xAxis[0].options.maxRange,S=this.scrollButtonSize,E=this.scrollbarHeight;if(!this.hasDragged||p(e)){if(t=g(t-u/2),i=g(i+u/2),!M(t)||!M(i)){if(!f)return;e=0,s=A(l.width,v.width)}this.left=A(l.left,d.plotLeft+S+(b?d.plotWidth:0));var w=this.size=n=A(l.len,(b?d.plotHeight:d.plotWidth)-2*S);o=b?E:n+2*S,e=A(e,l.toPixels(t,!0)),s=A(s,l.toPixels(i,!0)),M(e)&&Math.abs(e)!==1/0||(e=0,s=o);var C=l.toValue(e,!0),O=l.toValue(s,!0),z=Math.abs(g(O-C));z<y?this.grabbedLeft?e=l.toPixels(O-y-u,!0):this.grabbedRight&&(s=l.toPixels(C+y+u,!0)):p(k)&&g(z-u)>k&&(this.grabbedLeft?e=l.toPixels(O-k-u,!0):this.grabbedRight&&(s=l.toPixels(C+k+u,!0))),this.zoomedMax=c(Math.max(e,s),0,w),this.zoomedMin=c(this.fixedWidth?this.zoomedMax-this.fixedWidth:Math.min(e,s),0,w),this.range=this.zoomedMax-this.zoomedMin,w=Math.round(this.zoomedMax);var D=Math.round(this.zoomedMin);x&&(this.navigatorGroup.attr({visibility:"inherit"}),h=f&&!this.hasDragged?"animate":"attr",this.drawMasks(D,w,b,h),this.drawOutline(D,w,b,h),this.navigatorOptions.handles.enabled&&(this.drawHandle(D,0,b,h),this.drawHandle(w,1,b,h))),this.scrollbar&&(b?(a=this.top-S,r=this.left-E+(x||!v.opposite?0:(v.titleOffset||0)+v.axisTitleMargin),E=n+2*S):(a=this.top+(x?this.height:-E),r=this.left-S),this.scrollbar.position(r,a,o,E),this.scrollbar.setRange(this.zoomedMin/(n||1),this.zoomedMax/(n||1))),this.rendered=!0,m(this,"afterRender")}},e.prototype.addMouseEvents=function(){var t,i,e=this,s=e.chart,o=s.container,r=[];e.mouseMoveHandler=t=function(t){e.onMouseMove(t)},e.mouseUpHandler=i=function(t){e.onMouseUp(t)},(r=e.getPartsEvents("mousedown")).push(l(s.renderTo,"mousemove",t),l(o.ownerDocument,"mouseup",i),l(s.renderTo,"touchmove",t),l(o.ownerDocument,"touchend",i)),r.concat(e.getPartsEvents("touchstart")),e.eventsToUnbind=r,e.series&&e.series[0]&&r.push(l(e.series[0].xAxis,"foundExtremes",function(){s.navigator.modifyNavigatorAxisExtremes()}))},e.prototype.getPartsEvents=function(t){var i=this,e=[];return["shades","handles"].forEach(function(s){i[s].forEach(function(o,r){e.push(l(o.element,t,function(t){i[s+"Mousedown"](t,r)}))})}),e},e.prototype.shadesMousedown=function(t,i){t=(null===(e=this.chart.pointer)||void 0===e?void 0:e.normalize(t))||t;var e,s,o,r,a,n=this.chart,h=this.xAxis,d=this.zoomedMin,l=this.size,c=this.range,g=this.left,u=t.chartX;n.inverted&&(u=t.chartY,g=this.top),1===i?(this.grabbedCenter=u,this.fixedWidth=c,this.dragOffset=u-d):(a=u-g-c/2,0===i?a=Math.max(0,a):2===i&&a+c>=l&&(a=l-c,this.reversedExtremes?(a-=c,o=this.getUnionExtremes().dataMin):s=this.getUnionExtremes().dataMax),a!==d&&(this.fixedWidth=c,p((r=h.navigatorAxis.toFixedRange(a,a+c,o,s)).min)&&m(this,"setRange",{min:Math.min(r.min,r.max),max:Math.max(r.min,r.max),redraw:!0,eventArguments:{trigger:"navigator"}})))},e.prototype.handlesMousedown=function(t,i){t=(null===(e=this.chart.pointer)||void 0===e?void 0:e.normalize(t))||t;var e,s=this.chart,o=s.xAxis[0],r=this.reversedExtremes;0===i?(this.grabbedLeft=!0,this.otherHandlePos=this.zoomedMax,this.fixedExtreme=r?o.min:o.max):(this.grabbedRight=!0,this.otherHandlePos=this.zoomedMin,this.fixedExtreme=r?o.max:o.min),s.setFixedRange(void 0)},e.prototype.onMouseMove=function(t){var i,e,s=this,o=s.chart,r=s.navigatorSize,a=s.range,n=s.dragOffset,h=o.inverted,l=s.left;(!t.touches||0!==t.touches[0].pageX)&&(e=(t=(null===(i=o.pointer)||void 0===i?void 0:i.normalize(t))||t).chartX,h&&(l=s.top,e=t.chartY),s.grabbedLeft?(s.hasDragged=!0,s.render(0,0,e-l,s.otherHandlePos)):s.grabbedRight?(s.hasDragged=!0,s.render(0,0,s.otherHandlePos,e-l)):s.grabbedCenter&&(s.hasDragged=!0,e<n?e=n:e>r+n-a&&(e=r+n-a),s.render(0,0,e-n,e-n+a)),s.hasDragged&&s.scrollbar&&A(s.scrollbar.options.liveRedraw,!d&&!this.chart.boosted)&&(t.DOMType=t.type,setTimeout(function(){s.onMouseUp(t)},0)))},e.prototype.onMouseUp=function(t){var i,e,s,o,r,a,n=this.chart,h=this.xAxis,d=this.scrollbar,l=t.DOMEvent||t,c=n.inverted,g=this.rendered&&!this.hasDragged?"animate":"attr";(this.hasDragged&&(!d||!d.hasDragged)||"scrollbar"===t.trigger)&&(s=this.getUnionExtremes(),this.zoomedMin===this.otherHandlePos?o=this.fixedExtreme:this.zoomedMax===this.otherHandlePos&&(r=this.fixedExtreme),this.zoomedMax===this.size&&(r=this.reversedExtremes?s.dataMin:s.dataMax),0===this.zoomedMin&&(o=this.reversedExtremes?s.dataMax:s.dataMin),p((a=h.navigatorAxis.toFixedRange(this.zoomedMin,this.zoomedMax,o,r)).min)&&m(this,"setRange",{min:Math.min(a.min,a.max),max:Math.max(a.min,a.max),redraw:!0,animation:!this.hasDragged&&null,eventArguments:{trigger:"navigator",triggerOp:"navigator-drag",DOMEvent:l}})),"mousemove"!==t.DOMType&&"touchmove"!==t.DOMType&&(this.grabbedLeft=this.grabbedRight=this.grabbedCenter=this.fixedWidth=this.fixedExtreme=this.otherHandlePos=this.hasDragged=this.dragOffset=null),this.navigatorEnabled&&M(this.zoomedMin)&&M(this.zoomedMax)&&(e=Math.round(this.zoomedMin),i=Math.round(this.zoomedMax),this.shades&&this.drawMasks(e,i,c,g),this.outline&&this.drawOutline(e,i,c,g),this.navigatorOptions.handles.enabled&&Object.keys(this.handles).length===this.handles.length&&(this.drawHandle(e,0,c,g),this.drawHandle(i,1,c,g)))},e.prototype.removeEvents=function(){this.eventsToUnbind&&(this.eventsToUnbind.forEach(function(t){t()}),this.eventsToUnbind=void 0),this.removeBaseSeriesEvents()},e.prototype.removeBaseSeriesEvents=function(){var t=this.baseSeries||[];this.navigatorEnabled&&t[0]&&(!1!==this.navigatorOptions.adaptToUpdatedData&&t.forEach(function(t){k(t,"updatedData",this.updatedDataHandler)},this),t[0].xAxis&&k(t[0].xAxis,"foundExtremes",this.modifyBaseAxisExtremes))},e.prototype.init=function(i){var e=i.options,s=e.navigator||{},r=s.enabled,n=e.scrollbar||{},h=n.enabled,d=r&&s.height||0,c=h&&n.height||0,g=n.buttonsEnabled&&c||0;this.handles=[],this.shades=[],this.chart=i,this.setBaseSeries(),this.height=d,this.scrollbarHeight=c,this.scrollButtonSize=g,this.scrollbarEnabled=h,this.navigatorEnabled=r,this.navigatorOptions=s,this.scrollbarOptions=n,this.opposite=A(s.opposite,!!(!r&&i.inverted));var p=this,u=p.baseSeries,v=i.xAxis.length,x=i.yAxis.length,f=u&&u[0]&&u[0].xAxis||i.xAxis[0]||{options:{}};if(i.isDirtyBox=!0,p.navigatorEnabled?(p.xAxis=new t(i,y({breaks:f.options.breaks,ordinal:f.options.ordinal,overscroll:f.options.overscroll},s.xAxis,{id:"navigator-x-axis",yAxis:"navigator-y-axis",type:"datetime",index:v,isInternal:!0,offset:0,keepOrdinalPadding:!0,startOnTick:!1,endOnTick:!1,minPadding:0,maxPadding:0,zoomEnabled:!1},i.inverted?{offsets:[g,0,-g,0],width:d}:{offsets:[0,-g,0,g],height:d}),"xAxis"),p.yAxis=new t(i,y(s.yAxis,{id:"navigator-y-axis",alignTicks:!1,offset:0,index:x,isInternal:!0,reversed:A(s.yAxis&&s.yAxis.reversed,i.yAxis[0]&&i.yAxis[0].reversed,!1),zoomEnabled:!1},i.inverted?{width:d}:{height:d}),"yAxis"),u||s.series.data?p.updateNavigatorSeries(!1):0===i.series.length&&(p.unbindRedraw=l(i,"beforeRedraw",function(){i.series.length>0&&!p.series&&(p.setBaseSeries(),p.unbindRedraw())})),p.reversedExtremes=i.inverted&&!p.xAxis.reversed||!i.inverted&&p.xAxis.reversed,p.renderElements(),p.addMouseEvents()):(p.xAxis={chart:i,navigatorAxis:{fake:!0},translate:function(t,e){var s=i.xAxis[0],o=s.getExtremes(),r=s.len-2*g,a=E("min",s.options.min,o.dataMin),n=E("max",s.options.max,o.dataMax)-a;return e?t*n/r+a:r*(t-a)/n},toPixels:function(t){return this.translate(t)},toValue:function(t){return this.translate(t,!0)}},p.xAxis.navigatorAxis.axis=p.xAxis,p.xAxis.navigatorAxis.toFixedRange=o.prototype.toFixedRange.bind(p.xAxis.navigatorAxis)),i.options.scrollbar.enabled){var m=y(i.options.scrollbar,{vertical:i.inverted});!M(m.margin)&&p.navigatorEnabled&&(m.margin=i.inverted?-3:3),i.scrollbar=p.scrollbar=new a(i.renderer,m,i),l(p.scrollbar,"changed",function(t){var i=p.size,e=i*this.to,s=i*this.from;p.hasDragged=p.scrollbar.hasDragged,p.render(0,0,s,e),this.shouldUpdateExtremes(t.DOMType)&&setTimeout(function(){p.onMouseUp(t)})})}p.addBaseSeriesEvents(),p.addChartEvents()},e.prototype.getUnionExtremes=function(t){var i,e=this.chart.xAxis[0],s=this.xAxis,o=s.options,r=e.options;return t&&null===e.dataMin||(i={dataMin:A(o&&o.min,E("min",r.min,e.dataMin,s.dataMin,s.min)),dataMax:A(o&&o.max,E("max",r.max,e.dataMax,s.dataMax,s.max))}),i},e.prototype.setBaseSeries=function(t,i){var e=this.chart,s=this.baseSeries=[];t=t||e.options&&e.options.navigator.baseSeries||(e.series.length?f(e.series,function(t){return!t.options.isInternal}).index:0),(e.series||[]).forEach(function(i,e){!i.options.isInternal&&(i.options.showInNavigator||(e===t||i.options.id===t)&&!1!==i.options.showInNavigator)&&s.push(i)}),this.xAxis&&!this.xAxis.navigatorAxis.fake&&this.updateNavigatorSeries(!0,i)},e.prototype.updateNavigatorSeries=function(t,i){var e,s,o,r=this,a=r.chart,n=r.baseSeries,d={enableMouseTracking:!1,index:null,linkedTo:null,group:"nav",padXAxis:!1,xAxis:"navigator-x-axis",yAxis:"navigator-y-axis",showInLegend:!1,stacking:void 0,isInternal:!0,states:{inactive:{opacity:1}}},l=r.series=(r.series||[]).filter(function(t){var i=t.baseSeries;return!(0>n.indexOf(i))||(i&&(k(i,"updatedData",r.updatedDataHandler),delete i.navigatorSeries),t.chart&&t.destroy(),!1)}),c=r.navigatorOptions.series;n&&n.length&&n.forEach(function(t){var g=t.navigatorSeries,p=x({color:t.color,visible:t.visible},b(c)?h.navigator.series:c);if(!g||!1!==r.navigatorOptions.adaptToUpdatedData){d.name="Navigator "+n.length,o=(e=t.options||{}).navigatorOptions||{},p.dataLabels=S(p.dataLabels),(s=y(e,d,p,o)).pointRange=A(p.pointRange,o.pointRange,h.plotOptions[s.type||"line"].pointRange);var u=o.data||p.data;r.hasNavigatorData=r.hasNavigatorData||!!u,s.data=u||e.data&&e.data.slice(0),g&&g.options?g.update(s,i):(t.navigatorSeries=a.initSeries(s),a.setSortedData(),t.navigatorSeries.baseSeries=t,l.push(t.navigatorSeries))}}),(c.data&&!(n&&n.length)||b(c))&&(r.hasNavigatorData=!1,(c=S(c)).forEach(function(t,i){d.name="Navigator "+(l.length+1),(s=y(h.navigator.series,{color:a.series[i]&&!a.series[i].options.isInternal&&a.series[i].color||a.options.colors[i]||a.options.colors[0]},d,t)).data=t.data,s.data&&(r.hasNavigatorData=!0,l.push(a.initSeries(s)))})),t&&this.addBaseSeriesEvents()},e.prototype.addBaseSeriesEvents=function(){var t=this,i=this,e=i.baseSeries||[];e[0]&&e[0].xAxis&&e[0].eventsToUnbind.push(l(e[0].xAxis,"foundExtremes",this.modifyBaseAxisExtremes)),e.forEach(function(e){e.eventsToUnbind.push(l(e,"show",function(){this.navigatorSeries&&this.navigatorSeries.setVisible(!0,!1)})),e.eventsToUnbind.push(l(e,"hide",function(){this.navigatorSeries&&this.navigatorSeries.setVisible(!1,!1)})),!1!==t.navigatorOptions.adaptToUpdatedData&&e.xAxis&&e.eventsToUnbind.push(l(e,"updatedData",t.updatedDataHandler)),e.eventsToUnbind.push(l(e,"remove",function(){this.navigatorSeries&&(v(i.series,this.navigatorSeries),p(this.navigatorSeries.options)&&this.navigatorSeries.remove(!1),delete this.navigatorSeries)}))})},e.prototype.getBaseSeriesMin=function(t){return this.baseSeries.reduce(function(t,i){return Math.min(t,i.xData&&i.xData.length?i.xData[0]:t)},t)},e.prototype.modifyNavigatorAxisExtremes=function(){var t=this.xAxis;if(void 0!==t.getExtremes){var i=this.getUnionExtremes(!0);i&&(i.dataMin!==t.min||i.dataMax!==t.max)&&(t.min=i.dataMin,t.max=i.dataMax)}},e.prototype.modifyBaseAxisExtremes=function(){var t,i,e,s=this.chart.navigator,o=this.getExtremes(),r=o.min,a=o.max,n=o.dataMin,h=o.dataMax,d=a-r,l=s.stickToMin,c=s.stickToMax,g=A(null===(t=this.ordinal)||void 0===t?void 0:t.convertOverscroll(this.options.overscroll),0),p=s.series&&s.series[0],u=!!this.setExtremes;!(this.eventArgs&&"rangeSelectorButton"===this.eventArgs.trigger)&&(l&&(i=(e=n)+d),c&&(i=h+g,l||(e=Math.max(n,i-d,s.getBaseSeriesMin(p&&p.xData?p.xData[0]:-Number.MAX_VALUE)))),u&&(l||c)&&M(e)&&(this.min=this.userMin=e,this.max=this.userMax=i)),s.stickToMin=s.stickToMax=null},e.prototype.updatedDataHandler=function(){var t=this.chart.navigator,i=this.navigatorSeries,e=t.reversedExtremes?0===Math.round(t.zoomedMin):Math.round(t.zoomedMax)>=Math.round(t.size);t.stickToMax=A(this.chart.options.navigator&&this.chart.options.navigator.stickToMax,e),t.stickToMin=t.shouldStickToMin(this,t),i&&!t.hasNavigatorData&&(i.options.pointStart=this.xData[0],i.setData(this.options.data,!1,null,!1))},e.prototype.shouldStickToMin=function(t,i){var e=i.getBaseSeriesMin(t.xData[0]),s=t.xAxis,o=s.max,r=s.min,a=s.options.range;return!!(M(o)&&M(r))&&(a&&o-e>0?o-e<a:r<=e)},e.prototype.addChartEvents=function(){this.eventsToUnbind||(this.eventsToUnbind=[]),this.eventsToUnbind.push(l(this.chart,"redraw",function(){var t=this.navigator,i=t&&(t.baseSeries&&t.baseSeries[0]&&t.baseSeries[0].xAxis||this.xAxis[0]);i&&t.render(i.min,i.max)}),l(this.chart,"getMargins",function(){var t=this.navigator,i=t.opposite?"plotTop":"marginBottom";this.inverted&&(i=t.opposite?"marginRight":"plotLeft"),this[i]=(this[i]||0)+(t.navigatorEnabled||!this.inverted?t.height+t.scrollbarHeight:0)+t.navigatorOptions.margin}),l(e,"setRange",function(t){this.chart.xAxis[0].setExtremes(t.min,t.max,t.redraw,t.animation,t.eventArguments)}))},e.prototype.destroy=function(){var t=this;this.removeEvents(),this.xAxis&&(v(this.chart.xAxis,this.xAxis),v(this.chart.axes,this.xAxis)),this.yAxis&&(v(this.chart.yAxis,this.yAxis),v(this.chart.axes,this.yAxis)),(this.series||[]).forEach(function(t){t.destroy&&t.destroy()}),["series","xAxis","yAxis","shades","outline","scrollbarTrack","scrollbarRifles","scrollbarGroup","scrollbar","navigatorGroup","rendered"].forEach(function(i){t[i]&&t[i].destroy&&t[i].destroy(),t[i]=null}),[this.handles].forEach(function(t){u(t)})},e}()}),e(i,"Stock/Navigator/StandaloneNavigatorDefaults.js",[],function(){return{chart:{height:70,margin:[0,5,0,5]},exporting:{enabled:!1},legend:{enabled:!1},navigator:{enabled:!1},plotOptions:{series:{states:{hover:{enabled:!1}},marker:{enabled:!1}}},scrollbar:{enabled:!1},title:{text:""},tooltip:{enabled:!1},xAxis:{visible:!1},yAxis:{height:0,visible:!1}}}),e(i,"Stock/Navigator/StandaloneNavigator.js",[i["Core/Chart/Chart.js"],i["Stock/Navigator/Navigator.js"],i["Core/Globals.js"],i["Core/Utilities.js"],i["Core/Axis/Axis.js"],i["Stock/Navigator/StandaloneNavigatorDefaults.js"]],function(t,i,e,s,o,r){var a=s.merge,n=s.addEvent,h=s.fireEvent,d=s.pick;return function(){function s(s,o){this.boundAxes=[],this.userOptions=o,this.chartOptions=a(e.getOptions(),r,{navigator:o});var n=new t(s,this.chartOptions);n.options=a(n.options,{navigator:{enabled:!0},scrollbar:{enabled:!0}}),this.chartOptions.navigator&&this.chartOptions.scrollbar&&(this.chartOptions.navigator.enabled=!0,this.chartOptions.scrollbar.enabled=!0),this.navigator=new i(n),n.navigator=this.navigator,this.initNavigator()}return s.navigator=function(t,i){var o=new s(t,i);return e.navigators?e.navigators.push(o):e.navigators=[o],o},s.prototype.bind=function(i,e){var s=this;void 0===e&&(e=!0);var r=this,a=i instanceof t?i.xAxis[0]:i;if(a instanceof o){var h=this.navigator.xAxis,d=h.min,l=h.max,c=[];if(e){var g=n(a,"setExtremes",function(t){("pan"===t.trigger||"zoom"===t.trigger||"mouseWheelZoom"===t.trigger)&&r.setRange(t.min,t.max,!0,"pan"!==t.trigger,{trigger:a})});c.push(g)}var p=n(this.navigator,"setRange",function(t){a.setExtremes(t.min,t.max,t.redraw,t.animation)});c.push(p);var u=this.boundAxes.filter(function(t){return t.axis===a})[0];u||(u={axis:a,callbacks:[]},this.boundAxes.push(u)),u.callbacks=c,a.series.forEach(function(t){t.options.showInNavigator&&r.addSeries(t.options)}),a.setExtremes(d,l),n(a,"destroy",function(t){t.keepEvents||s.unbind(a)})}},s.prototype.unbind=function(t){if(!t){this.boundAxes.forEach(function(t){t.callbacks.forEach(function(t){return t()})}),this.boundAxes.length=0;return}for(var i=t instanceof o?t:t.xAxis[0],e=this.boundAxes.length-1;e>=0;e--)this.boundAxes[e].axis===i&&(this.boundAxes[e].callbacks.forEach(function(t){return t()}),this.boundAxes.splice(e,1))},s.prototype.destroy=function(){this.boundAxes.forEach(function(t){t.callbacks.forEach(function(t){return t()})}),this.boundAxes.length=0,this.navigator.destroy(),this.navigator.chart.destroy()},s.prototype.update=function(t,i){this.chartOptions=a(this.chartOptions,{navigator:t}),this.navigator.chart.update(this.chartOptions,i)},s.prototype.redraw=function(){this.navigator.chart.redraw()},s.prototype.addSeries=function(t){this.navigator.chart.addSeries(a(t,{showInNavigator:d(t.showInNavigator,!0)})),this.navigator.setBaseSeries()},s.prototype.initNavigator=function(){var t,i=this.navigator;i.top=1,i.xAxis.setScale(),i.yAxis.setScale(),i.xAxis.render(),i.yAxis.render(),null===(t=i.series)||void 0===t||t.forEach(function(t){t.translate(),t.render(),t.redraw()});var e=this.getInitialExtremes(),s=e.min,o=e.max;i.chart.xAxis[0].userMin=s,i.chart.xAxis[0].userMax=o,i.render(s,o)},s.prototype.getRange=function(){var t=this.navigator.chart.xAxis[0].getExtremes(),i=t.min,e=t.max,s=this.navigator.xAxis.getExtremes(),o=s.userMin,r=s.userMax,a=s.min,n=s.max;return{min:d(i,a),max:d(e,n),dataMin:a,dataMax:n,userMin:o,userMax:r}},s.prototype.setRange=function(t,i,e,s,o){h(this.navigator,"setRange",{min:t,max:i,redraw:e,animation:s,eventArguments:a(o,{trigger:"navigator"})})},s.prototype.getInitialExtremes=function(){var t=this.navigator.xAxis.getExtremes();return{min:t.min,max:t.max}},s}()}),e(i,"masters/modules/navigator.src.js",[i["Core/Globals.js"],i["Stock/Navigator/StandaloneNavigator.js"],i["Stock/Navigator/NavigatorComposition.js"]],function(t,i,e){t.StandaloneNavigator=t.StandaloneNavigator||i,e.compose(t.Chart,t.Axis,t.Series),t.navigator=i.navigator})});