$(document).ready(function () {
  fonction();
  deploiment();
  dernierPaiement();
  salaireParMois();
});

//if change year
$("#annee").change(function () {
  salaireParMois();
});

const fonction = async () => {
  var serie = "";

  await $.ajax({
    url: url + "/dash/salaireFonction",
    type: "GET",
    datatype: "json",
    success: (resp) => {
      console.log(resp);
      if (resp != null) {
        serie = resp;
      }
    },
  });
  Highcharts.chart("container2", {
    chart: {
      type: "variablepie",
    },
    credits: {
      enabled: false,
    },
    navigation: {
      buttonOptions: {
        enabled: false,
      },
    },
    title: {
      text: "Repartion des employes par fonction",
      align: "center",
    },
    tooltip: {
      headerFormat: "",
      pointFormat:
        '<span style="color:{point.color}">\u25CF</span> <b> {point.name}</b><br/>',
    },
    plotOptions: {
      variablepie: {
        allowPointSelect: true,
        cursor: "pointer",
        dataLabels: {
          enabled: false,
        },
        showInLegend: true,
      },
    },
    series: [
      {
        minPointSize: 10,
        innerSize: "35%",
        zMin: 0,
        name: "countries",
        borderRadius: 5,
        data: serie,
      },
    ],
  });
};
// const deploiment
const deploiment = async () => {
  var serie = "";
  var category = "";

  await $.ajax({
    url: url + "/dash/salaireDeploiement",
    type: "GET",
    datatype: "json",
    success: (resp) => {
      if (resp != null) {
        serie = resp.serie;
        category = resp.category;
      }
    },
  });

  Highcharts.chart("container1", {
    chart: {
      type: "cylinder",
      options3d: {
        enabled: true,
        alpha: 15,
        beta: 15,
        depth: 60,
        viewDistance: 35,
      },
    },
    title: {
      text: "Deploiement du personnel",
    },
    credits: {
      enabled: false,
    },
    xAxis: {
      categories: category,
      title: {
        text: "Deploiement du personnel",
      },
      labels: {
        skew3d: true,
      },
    },
    yAxis: {
      title: {
        margin: 20,
        text: "Nombre",
      },
      labels: {
        skew3d: true,
      },
    },
    tooltip: {
      headerFormat: "{point.x}<br>",
    },
    plotOptions: {
      series: {
        depth: 30,
        colorByPoint: true,
      },
    },
    series: [
      {
        data: serie,
        name: "Nombre",
        showInLegend: false,
      },
    ],
  });
};

const salaireParMois = async () => {
  var serie = "";
  var category = "";
  var annee = $("#annee").val();

  await $.ajax({
    url: url + "/dash/salaireParMoisData",
    type: "POST",
    data: { annee: annee },
    datatype: "json",
    success: (resp) => {
      if (resp != null) {
        serie = resp.serie;
        category = resp.category;
      }
    },
  });

  Highcharts.chart("container3", {
    chart: {
      type: "column",
      options3d: {
        enabled: false,
        alpha: 15,
        beta: 15,
        depth: 60,
        viewDistance: 35,
      },
    },
    title: {
      text: "Salaires net payes par Mois",
    },
    credits: {
      enabled: false,
    },
    xAxis: {
      categories: category,
      title: {
        text: "Salaire net",
      },
      labels: {
        skew3d: false,
      },
    },
    yAxis: {
      title: {
        margin: 20,
        text: "Montant",
      },
      labels: {
        skew3d: false,
      },
    },
    tooltip: {
      headerFormat: "{point.x}<br>",
    },
    plotOptions: {
      series: {
        depth: 0,
        colorByPoint: true,
      },
    },
    series: [
      {
        data: serie,
        name: "Nombre",
        showInLegend: false,
      },
    ],
  });
};

const dernierPaiement = () => {
  $.ajax({
    url: url + "/dash/dernierPaiement",
    type: "GET",
    dataType: "JSON",
    success: function (response) {
      $("#card1").html(response.paie.totalNetPayer);
      $("#card2").html(response.paie.montantHeure135);
      $("#card3").html(response.paie.montantHeure160);
      $("#card4").html(response.paie.montantHeure200);
    },
  });
};
