<?= $this->extend("layout/index"); ?>
<?= $this->section('content'); ?>

<div class="content-wrapper" style="min-height: 357.039px;">
    <section class="content">
        <div class="row" style="margin-top:10px">
            <div class="col-md-4">
                <h2 class="text-bold"><?= \auth()->user()->last_name . ", " . \auth()->user()->first_name ?></h2>
                <?php if (!empty(session()->getFlashdata('message'))) {
                    echo "<div class='row'>" . session()->getFlashdata('message') . "</div>";
                } ?>

                <?php echo form_open_multipart($locale . "/volontaire/language/save"); ?>
                <div class="card card-default">
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-6">
                                <?= form_label("Langue <font color='red'>*</font>"); ?>
                                <?php
                                echo form_dropdown('langue_id', $langues, set_value('langue_id'), "class = 'form-control' id='langue_id'");
                                ?>
                                <?= !empty(validation_show_error('langue_id')) ? "<p class='text-danger'>" . validation_show_error('langue_id') . "</p>" : "" ?>

                            </div>

                            <div class="col-md-6">
                                <?= form_label("Parler <font color='red'>*</font>"); ?>
                                <?php
                                echo form_dropdown('niveau_oral', $niveaux, set_value('niveau_oral'), "class = 'form-control' id='niveau_oral'");
                                ?>
                                <?= !empty(validation_show_error('niveau_oral')) ? "<p class='text-danger'>" . validation_show_error('niveau_oral') . "</p>" : "" ?>
                            </div>

                            <div class="col-md-6">
                                <?= form_label("Ecrire <font color='red'>*</font>"); ?>
                                <?php
                                echo form_dropdown('niveau_ecrit', $niveaux, set_value('niveau_ecrit'), "class = 'form-control' id='niveau_ecrit'");
                                ?>
                                <?= !empty(validation_show_error('niveau_ecrit')) ? "<p class='text-danger'>" . validation_show_error('niveau_ecrit') . "</p>" : "" ?>
                            </div>

                            <div class="col-md-6">
                                <?= form_label("Lire <font color='red'>*</font>"); ?>
                                <?php
                                echo form_dropdown('niveau_lire', $niveaux, set_value('niveau_lire'), "class = 'form-control' id='niveau_lire'");
                                ?>
                                <?= !empty(validation_show_error('niveau_lire')) ? "<p class='text-danger'>" . validation_show_error('niveau_lire') . "</p>" : "" ?>
                            </div>
                        </div>
                    </div>
                    <div class="card-footer">
                        <?php
                        echo form_submit("mysubmit", "Enregistrer", "class='btn btn-primary btn-sm mt-2'");
                        ?>
                    </div>
                </div>
                <?php echo form_close(); ?>
            </div>

            <div class="col-md-8">
                <h2 class="text-bold">Compétences linguistiques</h2>

                <?php

                if (!empty($languages)) {
                    foreach ($languages as $language) {

                ?>
                        <?php echo form_open_multipart($locale . "/volontaire/language/edit", NULL, ['id' => $language->id]); ?>
                        <div class="card card-default">
                            <div class="card-body">
                                <div class="row">
                                    <div class="col-md-6">
                                        <?= form_label("Langue <font color='red'>*</font>"); ?>
                                        <?php
                                        echo form_dropdown('langue_id', $langues, set_value('langue_id', $language->langue_id), "class = 'form-control' id='langue_id'");
                                        ?>
                                        <?= !empty(validation_show_error('langue_id')) ? "<p class='text-danger'>" . validation_show_error('langue_id') . "</p>" : "" ?>

                                    </div>

                                    <div class="col-md-6">
                                        <?= form_label("Parler <font color='red'>*</font>"); ?>
                                        <?php
                                        echo form_dropdown('niveau_oral', $niveaux, set_value('niveau_oral', $language->niveau_oral), "class = 'form-control' id='niveau_oral'");
                                        ?>
                                        <?= !empty(validation_show_error('niveau_oral')) ? "<p class='text-danger'>" . validation_show_error('niveau_oral') . "</p>" : "" ?>
                                    </div>

                                    <div class="col-md-6">
                                        <?= form_label("Ecrire <font color='red'>*</font>"); ?>
                                        <?php
                                        echo form_dropdown('niveau_ecrit', $niveaux, set_value('niveau_ecrit', $language->niveau_ecrit), "class = 'form-control' id='niveau_ecrit'");
                                        ?>
                                        <?= !empty(validation_show_error('niveau_ecrit')) ? "<p class='text-danger'>" . validation_show_error('niveau_ecrit') . "</p>" : "" ?>
                                    </div>

                                    <div class="col-md-6">
                                        <?= form_label("Lire <font color='red'>*</font>"); ?>
                                        <?php
                                        echo form_dropdown('niveau_lire', $niveaux, set_value('niveau_lire', $language->niveau_lire), "class = 'form-control' id='niveau_lire'");
                                        ?>
                                        <?= !empty(validation_show_error('niveau_lire')) ? "<p class='text-danger'>" . validation_show_error('niveau_lire') . "</p>" : "" ?>
                                    </div>
                                </div>
                            </div>
                            <div class="card-footer">
                                <?php
                                echo form_submit("mysubmit", "Modifier", "class='btn btn-primary btn-sm mt-2'");
                                echo anchor($locale . "/volontaire/language/delete/" . $language->id, 'Supprimer', "class='btn btn-danger btn-sm mt-2'");
                                ?>
                            </div>
                        </div>
                        <?php echo form_close(); ?>

                <?php }
                } ?>
            </div>
        </div>

    </section>
</div>

<?= $this->endSection(); ?>