<?= $this->extend("layout/index"); ?>
<?= $this->section('content'); ?>

<div class="content-wrapper" style="min-height: 357.039px;">
    <section class="content">
        <?php echo form_open_multipart($locale . "/volontaire/save", null, ['id' => $volontaire->id]); ?>
        <div class="row" style="margin-top:10px">
            <div class="col-md-9">
                <h2 class="text-bold"><?= \auth()->user()->last_name . ", " . \auth()->user()->first_name ?></h2>
                
                <?php if (!empty(session()->getFlashdata('message'))) {
                    echo "<div class='row'>".session()->getFlashdata('message')."</div>";
                } ?>

                <div class="card card-default">
                    <div class="card-header">
                        <h3 class="card-title text-bold">
                            Informations de base
                        </h3>
                        <p class='text-bold float-right'><font color='red'>*</font> Champ est obligatoire</p>
                    </div>

                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-6">
                                <?php ?>
                                <?= form_label("Nom de famille <font color='red'>*</font>"); ?>
                                <?php
                                $nom = [
                                    'type'  => 'text',
                                    'name'  => 'nom',
                                    'id'    => 'nom',
                                    'value' => set_value('nom', $volontaire->nom),
                                    'placeholder' => "nom",
                                    'class' => 'form-control',
                                ];

                                echo form_input($nom);
                                ?>
                                <?= !empty(validation_show_error('nom')) ? "<p class='text-danger'>" . validation_show_error('nom') . "</p>" : "" ?>

                            </div>
                            <div class="col-md-6">
                                <?= form_label("Prénoms <font color='red'>*</font>"); ?>
                                <?php
                                $prenom = [
                                    'type'  => 'text',
                                    'name'  => 'prenom',
                                    'id'    => 'prenom',
                                    'value' => set_value('prenom', $volontaire->prenom),
                                    'placeholder' => "Prénoms",
                                    'class' => 'form-control',
                                ];

                                echo form_input($prenom);
                                ?>
                                <?= !empty(validation_show_error('prenom')) ? "<p class='text-danger'>" . validation_show_error('prenom') . "</p>" : "" ?>

                            </div>

                            <div class="col-md-6">
                                <?= form_label("Surnom"); ?>
                                <?php
                                $surnom = [
                                    'type'  => 'text',
                                    'name'  => 'surnom',
                                    'id'    => 'surnom',
                                    'value' => set_value('surnom', $volontaire->surnom),
                                    'placeholder' => "Nom d'appel",
                                    'class' => 'form-control',
                                ];

                                echo form_input($surnom);
                                ?>
                                <?= !empty(validation_show_error('surnom')) ? "<p class='text-danger'>" . validation_show_error('surnom') . "</p>" : "" ?>

                            </div>

                            <div class="col-md-6">
                                <?= form_label("Genre <font color='red'>*</font>"); ?>
                                <?php
                                echo form_dropdown('genre', $genres, set_value('genre', $volontaire->genre), "class = 'form-control'");
                                ?>
                                <?= !empty(validation_show_error('genre')) ? "<p class='text-danger'>" . validation_show_error('genre') . "</p>" : "" ?>

                            </div>

                            <div class="col-md-6">
                                <?= form_label("Téléphone <font color='red'>*</font>"); ?>
                                <?php
                                $telephone = [
                                    'type'  => 'text',
                                    'name'  => 'telephone',
                                    'id'    => 'telephone',
                                    'value' => set_value('telephone', $volontaire->telephone),
                                    'placeholder' => "Téléphone",
                                    'class' => 'form-control',
                                ];

                                echo form_input($telephone);
                                ?>
                                <?= !empty(validation_show_error('telephone')) ? "<p class='text-danger'>" . validation_show_error('telephone') . "</p>" : "" ?>

                            </div>

                            <div class="col-md-6">
                                <?= form_label("E-mail <font color='red'>*</font>"); ?>
                                <?php
                                $email = [
                                    'type'  => 'text',
                                    'name'  => 'email',
                                    'id'    => 'email',
                                    'value' => set_value('email', $volontaire->email),
                                    'placeholder' => "E-mail",
                                    'class' => 'form-control',
                                ];

                                echo form_input($email);
                                ?>
                                <?= !empty(validation_show_error('email')) ? "<p class='text-danger'>" . validation_show_error('email') . "</p>" : "" ?>

                            </div>

                            <div class="col-md-6">
                                <?= form_label("Date de naissance <font color='red'>*</font>"); ?>
                                <?php $date = $volontaire->birthDate ? $volontaire->birthDate : set_value('birthDate') ?>
                                <div class="input-group date" id="birthDate" data-target-input="nearest">
                                    <?= form_input('birthDate', $date, "class='form-control datetimepicker-input', id='birthDate' placeholder='" . lang("Employer.employer_form_birthDate") . "'") ?>
                                    <div class="input-group-append" data-target="#birthDate" data-toggle="datetimepicker">
                                        <div class="input-group-text"><i class="fa fa-calendar"></i></div>
                                    </div>
                                </div>
                                <?= !empty(validation_show_error('birthDate')) ? "<p class='text-danger'>" . validation_show_error('birthDate') . "</p>" : "" ?>

                            </div>

                            <div class="col-md-6">
                                <?= form_label("Pays d'éligibilité à la sécurité sociale"); ?>
                                <?php
                                echo form_dropdown('paysEligibiliteId', $pays, set_value('paysEligibiliteId', $volontaire->paysEligibiliteId), "class = 'form-control' id='paysEligibiliteId'");
                                ?>
                                <?= !empty(validation_show_error('paysEligibiliteId')) ? "<p class='text-danger'>" . validation_show_error('paysEligibiliteId') . "</p>" : "" ?>

                            </div>

                            <div class="col-md-6">
                                <?= form_label("Profession <font color='red'>*</font>"); ?>
                                <?php
                                $profession = [
                                    'type'  => 'text',
                                    'name'  => 'profession',
                                    'id'    => 'profession',
                                    'value' => set_value('profession', $volontaire->profession),
                                    'placeholder' => "Profession",
                                    'class' => 'form-control',
                                ];

                                echo form_input($profession);
                                ?>
                                <?= !empty(validation_show_error('profession')) ? "<p class='text-danger'>" . validation_show_error('profession') . "</p>" : "" ?>
                            </div>

                            <div class="col-md-6">
                                <?= form_label("Titre"); ?>
                                <?php
                                $titre = [
                                    'type'  => 'text',
                                    'name'  => 'titre',
                                    'id'    => 'titre',
                                    'value' => set_value('titre', $volontaire->titre),
                                    'placeholder' => "Titre",
                                    'class' => 'form-control',
                                ];

                                echo form_input($titre);
                                ?>
                                <?= !empty(validation_show_error('titre')) ? "<p class='text-danger'>" . validation_show_error('titre') . "</p>" : "" ?>

                            </div>
                            <div class="col-md-6">
                                <?= form_label("Est staff de la NS ? <font color='red'>*</font>"); ?>
                                <?php
                                echo form_dropdown('estStaff', $estStaff, set_value('estStaff', $volontaire->estStaff), "class = 'form-control' id='estStaff'");
                                ?>
                                <?= !empty(validation_show_error('estStaff')) ? "<p class='text-danger'>" . validation_show_error('estStaff') . "</p>" : "" ?>

                            </div>

                            <div class="col-md-6">
                                <?= form_label("Organisation <font color='red'>*</font>"); ?>
                                <?php
                                echo form_dropdown('organisationId', $organisations, set_value('organisationId', $volontaire->organisationId), "class = 'form-control' id='organisationId'");
                                ?>
                                <?= !empty(validation_show_error('organisationId')) ? "<p class='text-danger'>" . validation_show_error('organisationId') . "</p>" : "" ?>

                            </div>

                            <div class="col-md-6">
                                <?= form_label("Emplacement <font color='red'>*</font>"); ?>
                                <?php
                                echo form_dropdown('emplacement', $emplacements, set_value('emplacement', $volontaire->emplacement), "class = 'form-control' id='emplacement'");
                                ?>
                                <?= !empty(validation_show_error('emplacement')) ? "<p class='text-danger'>" . validation_show_error('emplacement') . "</p>" : "" ?>

                            </div>

                            <div class="col-md-6">
                                <?= form_label("Numéro d'intégration RH"); ?>
                                <?php
                                $numeroRH = [
                                    'type'  => 'text',
                                    'name'  => 'numeroRH',
                                    'id'    => 'numeroRH',
                                    'value' => set_value('numeroRH', $volontaire->numeroRH),
                                    'placeholder' => "Numéro d'intégration RH",
                                    'class' => 'form-control',
                                ];

                                echo form_input($numeroRH);
                                ?>
                                <?= !empty(validation_show_error('numeroRH')) ? "<p class='text-danger'>" . validation_show_error('numeroRH') . "</p>" : "" ?>

                            </div>

                            <div class="col-md-6">
                                <?= form_label("Type de contrat préféré"); ?>
                                <?php
                                echo form_dropdown('contratId', $contrats, set_value('contratId', $volontaire->contratId), "class = 'form-control' id='contratId'");
                                ?>
                                <?= !empty(validation_show_error('contratId')) ? "<p class='text-danger'>" . validation_show_error('contratId') . "</p>" : "" ?>

                            </div>

                        </div>
                    </div>
                </div>

                <div class="card card-default">
                    <div class="card-header">
                        <h3 class="card-title text-bold">Nationalite actuelle <font color='red'>*</font></h3>
                    </div>
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-6">
                                <?php
                                echo form_dropdown('nationaliteId', $pays, set_value('nationaliteId', $volontaire->nationaliteId), "class = 'form-control' id='nationaliteId'");
                                ?>
                                <?= !empty(validation_show_error('nationaliteId')) ? "<p class='text-danger'>" . validation_show_error('nationaliteId') . "</p>" : "" ?>

                            </div>

                        </div>
                    </div>
                </div>

                <div class="card card-default">
                    <div class="card-header">
                        <h3 class="card-title text-bold">Informations diverses</h3>
                    </div>
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-6">
                                <?= form_label("Type de contrat prefere"); ?>
                                <?php
                                echo form_dropdown('tailleChemiseId', $tailles, set_value('tailleChemiseId', $volontaire->tailleChemiseId), "class = 'form-control' id='tailleChemiseId'");
                                ?>
                                <?= !empty(validation_show_error('tailleChemiseId')) ? "<p class='text-danger'>" . validation_show_error('tailleChemiseId') . "</p>" : "" ?>

                            </div>

                            <div class="col-md-6">
                                <?= form_label("Pointure"); ?>
                                <?php
                                $pointure = [
                                    'type'  => 'text',
                                    'name'  => 'pointure',
                                    'id'    => 'pointure',
                                    'value' => set_value('pointure', $volontaire->pointure),
                                    'placeholder' => "Pointure",
                                    'class' => 'form-control',
                                ];

                                echo form_input($pointure);
                                ?>
                                <?= !empty(validation_show_error('pointure')) ? "<p class='text-danger'>" . validation_show_error('Pointure') . "</p>" : "" ?>

                            </div>

                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="card card-default">
                    <div class="card-header">
                        <h3 class="card-title text-bold">Actions</h3>
                    </div>

                    <div class="card-body">
                        <?php
                        echo form_submit("mysubmit", "Enregistrer les modifications", "class='btn btn-primary btn-sm btn-block mt-2'");
                        ?>
                        <?php
                        echo anchor($locale . '/volontaire/identite/pdf', 'Imprimer', "target='_blank' class='btn btn-success btn-sm btn-block btn-sm mt-2'");
                        ?>
                    </div>
                </div>
                <?php echo form_close(); ?>

                <?php echo form_open_multipart($locale . "/volontaire/identite/photo", null, ['id' => $volontaire->id]); ?>
                <div class="card card-default">
                    <div class="card-header">
                        <h3 class="card-title text-bold">Photo de profil</h3>
                    </div>
                    <div class="card-body">
                    <div class="row mb-3">
                        <?= form_label("Photo de profil"); ?>
                        <?php

                        $passportImagePath = [
                            'type'  => 'file',
                            'name'  => 'passportImagePath',
                            'id'    => 'passportImagePath',
                            'class' => 'form-control',
                        ];

                        echo form_upload($passportImagePath);
                        
                        ?>
                        <?= !empty(validation_show_error('passportImagePath')) ? "<p class='text-danger'>" . validation_show_error('passportImagePath') . "</p>" : "" ?>

                    </div>

                        <?php
                        echo form_submit("mysubmit", "Téléverser", "class='btn btn-primary btn-sm btn-block mt-2'");
                        ?>
                    </div>
                    <?php echo form_close(); ?>

                </div>
            </div>

    </section>
</div>


<?= $this->endSection(); ?>