<?= $this->extend("layout/index"); ?>
<?= $this->section('content'); ?>

<div class="content-wrapper" style="min-height: 357.039px;">
    <section class="content">
        <h2 class="text-bold"><?= \auth()->user()->last_name . ", " . \auth()->user()->first_name ?></h2>

        <div class="row" style="margin-top:10px">

            <div class="col-md-9">
                <?php if (!empty(session()->getFlashdata('message'))) {
                    echo "<div class='row'>" . session()->getFlashdata('message') . "</div>";
                } ?>
                <?php
                $id = (string)$experience->id;
                echo form_open_multipart($locale . "/volontaire/experience/save", 'class="email" id="myform"', ['id' => $id]); ?>

                <div class="card card-default">
                    <div class="card-header">
                        <h3 class="card-title text-bold">
                            Expérience
                        </h3>
                        <p class='text-bold float-right'>
                            <font color='red'>*</font> Champ est obligatoire
                        </p>
                    </div>
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-6">
                                <?= form_label("Type d'emploi <font color='red'>*</font>"); ?>
                                <?php
                                echo form_dropdown('type_id', $types, set_value('type_id', $experience->type_id), "class = 'form-control' id='type_id'");
                                ?>
                                <?= !empty(validation_show_error('type_id')) ? "<p class='text-danger'>" . validation_show_error('type_id') . "</p>" : "" ?>
                            </div>

                            <div class="col-md-6">
                                <?= form_label("Employeur <font color='red'>*</font>"); ?>
                                <?php
                                $employeur = [
                                    'type'  => 'text',
                                    'name'  => 'employeur',
                                    'id'    => 'employeur',
                                    'value' => set_value('employeur', $experience->employeur),
                                    'placeholder' => "Employeur",
                                    'class' => 'form-control',
                                ];

                                echo form_input($employeur);
                                ?>
                                <?= !empty(validation_show_error('employeur')) ? "<p class='text-danger'>" . validation_show_error('employeur') . "</p>" : "" ?>

                            </div>

                            <div class="col-md-6">
                                <?= form_label("Position <font color='red'>*</font>"); ?>
                                <?php
                                echo form_dropdown('position', $positions, set_value('position', $experience->position), "class = 'form-control' id='position'");
                                ?>
                                <?= !empty(validation_show_error('position')) ? "<p class='text-danger'>" . validation_show_error('position') . "</p>" : "" ?>

                            </div>

                            <div class="col-md-6">
                                <?= form_label("Domaines <font color='red'>*</font>"); ?>
                                <?php
                                echo form_dropdown('domaine', $domaines, set_value('domaine', $experience->domaine), "class = 'form-control' id='domaine'");
                                ?>
                                <?= !empty(validation_show_error('domaine')) ? "<p class='text-danger'>" . validation_show_error('domaine') . "</p>" : "" ?>

                            </div>

                            <div class="col-md-6">
                                <?= form_label("Responsabilites <font color='red'>*</font>"); ?>
                                <?php
                                $responsabilite = [
                                    'type'  => 'text',
                                    'name'  => 'responsabilite',
                                    'id'    => 'responsabilite',
                                    'value' => set_value('responsabilite', $experience->responsabilite),
                                    'placeholder' => "Responsabilites",
                                    'class' => 'form-control',
                                ];

                                echo form_input($responsabilite);
                                ?>
                                <?= !empty(validation_show_error('responsabilite')) ? "<p class='text-danger'>" . validation_show_error('responsabilite') . "</p>" : "" ?>
                            </div>

                            <div class="col-md-6">
                                <?= form_label("Description"); ?>
                                <?php
                                $description = [
                                    'type'  => 'text',
                                    'name'  => 'description',
                                    'id'    => 'description',
                                    'value' => set_value('description', $experience->description),
                                    'placeholder' => "Description",
                                    'class' => 'form-control',
                                ];

                                echo form_input($description);
                                ?>
                                <?= !empty(validation_show_error('description')) ? "<p class='text-danger'>" . validation_show_error('description') . "</p>" : "" ?>

                            </div>

                            <div class="col-md-6">
                                <?= form_label("Date de début <font color='red'>*</font>"); ?>
                                <?php $date = set_value('date_debut', $experience->date_debut) ?>
                                <div class="input-group date" id="date_debut" data-target-input="nearest">
                                    <?= form_input('date_debut', $date, "class='form-control datetimepicker-input', id='date_debut' placeholder='Date de début'") ?>
                                    <div class="input-group-append" data-target="#date_debut" data-toggle="datetimepicker">
                                        <div class="input-group-text"><i class="fa fa-calendar"></i></div>
                                    </div>
                                </div>
                                <?= !empty(validation_show_error('date_debut')) ? "<p class='text-danger'>" . validation_show_error('date_debut') . "</p>" : "" ?>
                            </div>

                            <div class="col-md-6">
                                <?= form_label("Date fin"); ?>
                                <?php $date = set_value('date_fin', $experience->date_fin) ?>
                                <div class="input-group date" id="date_fin" data-target-input="nearest">
                                    <?= form_input('date_fin', $date, "class='form-control datetimepicker-input', id='date_fin' placeholder='Date fin'") ?>
                                    <div class="input-group-append" data-target="#date_fin" data-toggle="datetimepicker">
                                        <div class="input-group-text"><i class="fa fa-calendar"></i></div>
                                    </div>
                                </div>
                                <?= !empty(validation_show_error('date_fin')) ? "<p class='text-danger'>" . validation_show_error('date_fin') . "</p>" : "" ?>
                            </div>

                        </div>
                    </div>
                    <div class="card-header">
                        <?php
                        echo form_submit("mysubmit", "Enregistrer", "class='btn btn-primary btn-sm'");
                        echo anchor($locale . '/volontaire/experiences', 'Retour', 'class="btn btn-default btn-sm"');
                        ?>
                    </div>
                </div>

                <?php echo form_close(); ?>
            </div>

    </section>
</div>

<?= $this->endSection(); ?>