<?= $this->extend("layout/index"); ?>
<?= $this->section('content'); ?>

<div class="content-wrapper" style="min-height: 357.039px;">
    <section class="content">
        <h2 class="text-bold"><?= \auth()->user()->last_name . ", " . \auth()->user()->first_name ?></h2>

        <div class="row" style="margin-top:10px">

            <div class="col-md-9">
                <?php if (!empty(session()->getFlashdata('message'))) {
                    echo "<div class='row'>" . session()->getFlashdata('message') . "</div>";
                } ?>

                <?php echo form_open_multipart($locale . "/volontaire/etude/save",); ?>

                <div class="card card-default">
                    <div class="card-header">
                        <h3 class="card-title text-bold">
                            Études faites
                        </h3>
                        <p class='text-bold float-right'>
                            <font color='red'>*</font> Champ est obligatoire
                        </p>
                    </div>
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-6">
                                <?= form_label("Type d'éducation <font color='red'>*</font>"); ?>
                                <?php
                                echo form_dropdown('type_id', $types, set_value('type_id'), "class = 'form-control' id='type_id'");
                                ?>
                                <?= !empty(validation_show_error('type_id')) ? "<p class='text-danger'>" . validation_show_error('type_id') . "</p>" : "" ?>
                            </div>

                            <div class="col-md-6">
                                <?= form_label("Nom du diplôme/qualification <font color='red'>*</font>"); ?>
                                <?php
                                $desc = [
                                    'type'  => 'text',
                                    'name'  => 'description_qualification',
                                    'id'    => 'description_qualification',
                                    'value' => set_value('description_qualification'),
                                    'placeholder' => "Nom du diplôme/qualification",
                                    'class' => 'form-control',
                                ];

                                echo form_input($desc);
                                ?>
                                <?= !empty(validation_show_error('description_qualification')) ? "<p class='text-danger'>" . validation_show_error('description_qualification') . "</p>" : "" ?>

                            </div>

                            <div class="col-md-6">
                                <?= form_label("Accent sur le degré <font color='red'>*</font>"); ?>
                                <?php
                                $accent = [
                                    'type'  => 'text',
                                    'name'  => 'accent_degre',
                                    'id'    => 'accent_degre',
                                    'value' => set_value('accent_degre'),
                                    'placeholder' => "Accent sur le degré",
                                    'class' => 'form-control',
                                ];

                                echo form_input($accent);
                                ?>
                                <?= !empty(validation_show_error('accent_degre')) ? "<p class='text-danger'>" . validation_show_error('accent_degre') . "</p>" : "" ?>

                            </div>

                            <div class="col-md-6">
                                <?= form_label("Institution <font color='red'>*</font>"); ?>
                                <?php
                                $institution = [
                                    'type'  => 'text',
                                    'name'  => 'institution',
                                    'id'    => 'institution',
                                    'value' => set_value('institution'),
                                    'placeholder' => "Institution",
                                    'class' => 'form-control',
                                ];

                                echo form_input($institution);
                                ?>
                                <?= !empty(validation_show_error('institution')) ? "<p class='text-danger'>" . validation_show_error('institution') . "</p>" : "" ?>

                            </div>

                            <div class="col-md-6">
                                <?= form_label("Ville / pays <font color='red'>*</font>"); ?>
                                <?php
                                $ville = [
                                    'type'  => 'text',
                                    'name'  => 'ville_pays',
                                    'id'    => 'ville_pays',
                                    'value' => set_value('ville_pays'),
                                    'placeholder' => "Ville et pays",
                                    'class' => 'form-control',
                                ];

                                echo form_input($ville);
                                ?>
                                <?= !empty(validation_show_error('ville_pays')) ? "<p class='text-danger'>" . validation_show_error('ville_pays') . "</p>" : "" ?>

                            </div>

                            <div class="col-md-6">
                                <?= form_label("Date de début <font color='red'>*</font>"); ?>
                                <?php $date = set_value('date_debut') ?>
                                <div class="input-group date" id="date_debut" data-target-input="nearest">
                                    <?= form_input('date_debut', $date, "class='form-control datetimepicker-input', id='date_debut' placeholder='Date de début'") ?>
                                    <div class="input-group-append" data-target="#date_debut" data-toggle="datetimepicker">
                                        <div class="input-group-text"><i class="fa fa-calendar"></i></div>
                                    </div>
                                </div>
                                <?= !empty(validation_show_error('date_debut')) ? "<p class='text-danger'>" . validation_show_error('date_debut') . "</p>" : "" ?>
                            </div>

                            <div class="col-md-6">
                                <?= form_label("Date de fin"); ?>
                                <?php $date = set_value('date_fin') ?>
                                <div class="input-group date" id="date_fin" data-target-input="nearest">
                                    <?= form_input('date_fin', $date, "class='form-control datetimepicker-input', id='date_fin' placeholder='Date de fin'") ?>
                                    <div class="input-group-append" data-target="#date_fin" data-toggle="datetimepicker">
                                        <div class="input-group-text"><i class="fa fa-calendar"></i></div>
                                    </div>
                                </div>
                                <?= !empty(validation_show_error('date_fin')) ? "<p class='text-danger'>" . validation_show_error('date_fin') . "</p>" : "" ?>
                            </div>

                            <div class="col-md-6">
                                <?= form_label("Informations complémentaires"); ?>
                                <?php
                                $ville = [
                                    'type'  => 'text',
                                    'name'  => 'informations_complementaire',
                                    'id'    => 'informations_complementaire',
                                    'value' => set_value('informations_complementaire'),
                                    'placeholder' => "Informations complémentaires",
                                    'class' => 'form-control',
                                ];

                                echo form_input($ville);
                                ?>
                                <?= !empty(validation_show_error('informations_complementaire')) ? "<p class='text-danger'>" . validation_show_error('informations_complementaire') . "</p>" : "" ?>

                            </div>

                        </div>
                    </div>
                    <div class="card-footer">
                        <?php
                        echo form_submit("mysubmit", "Enregistrer", "class='btn btn-primary btn-sm'");

                        echo anchor($locale.'/volontaire/etudes', 'Retour', 'class="btn btn-default btn-sm"');
                        ?>
                    </div>
                </div>

                <?php echo form_close(); ?>
            </div>

    </section>
</div>

<?= $this->endSection(); ?>