<?= $this->extend("layout/index"); ?>
<?= $this->section('content'); ?>

<div class="content-wrapper" style="min-height: 357.039px;">
    <section class="content">
        <?php echo form_open_multipart($locale . "/volontaire/document", null, []); ?>
        <div class="row" style="margin-top:10px">
            <div class="col-md-9">
                <h2 class="text-bold"><?= \auth()->user()->last_name . ", " . \auth()->user()->first_name ?></h2>
                <?php if (!empty(session()->getFlashdata('message'))) {
                    echo "<div class='row'>" .session()->getFlashdata('message')."</div>";
                } ?>
                <div class="card card-default">
                    <div class="card-header">
                        <h3 class="card-title text-bold">Documents</h3>
                        <p class='text-bold float-right'><font color='red'>*</font> Champ est obligatoire</p>
                    </div>

                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-3">
                                <?= form_label("Type de document <font color='red'>*</font>"); ?>
                                <?php
                                echo form_dropdown('type', $types, set_value('type'), "class = 'form-control' id='type'");
                                ?>
                                <?= !empty(validation_show_error('type')) ? "<p class='text-danger'>" . validation_show_error('type') . "</p>" : "" ?>

                            </div>
                            <div class="col-md-6">
                                <?= form_label("Document <font color='red'>*</font>"); ?>
                                <?php

                                $path = [
                                    'type'  => 'file',
                                    'name'  => 'path',
                                    'id'    => 'path',
                                    'class' => 'form-control',
                                ];

                                echo form_upload($path);
                                ?>
                            </div>
                            <div class="col-md-2">
                                <?php
                                echo form_submit("mysubmit", "Enregistrer", "class='btn btn-primary btn-sm btn-block mt-4'");
                                ?>
                            </div>
                        </div>

                        <div class="row mt-3">
                            <?php

                            use CodeIgniter\View\Table;

                            $table = new Table();

                            $template = [
                                'table_open' => '<table class="table table-bordered" id="">',
                            ];
                            $table->setTemplate($template);
                            $table->setHeading(['#', 'TYPE', 'PATH', 'ACTION']);

                            if (!empty($documents)) {
                                $i = 1;
                                foreach ($documents as $document) {
                                    $table->addRow([
                                        $i,
                                        $document->type,
                                        anchor("uploads/documents/" . $document->document_path, "<i class='fa fa-file-pdf'></i>".$document->document_path, ['target'=>'_blank']),
                                        anchor($locale . "/volontaire/document/delete/" . $document->id, "<i class='fa fa-trash'></i>", ['class' => 'text-danger'])
                                    ]);
                                    $i++;
                                }
                            }

                            echo $table->generate();

                            ?>
                        </div>

                    </div>
                </div>
            </div>

            <div class="col-md-3">
                
            </div>
        </div>

        <?php echo form_close(); ?>

    </section>
</div>


<?= $this->endSection(); ?>