<?= $this->extend("layout/index"); ?>
<?= $this->section('content'); ?>

<div class="content-wrapper" style="min-height: 357.039px;">
    <section class="content">
        <div class="row" style="margin-top:10px">
            <div class="col-md-12">
                <h2 class="text-bold"><?= \auth()->user()->last_name . ", " . \auth()->user()->first_name ?></h2>
                <?php if (!empty(session()->getFlashdata('message'))) {
                    echo "<div class='row'>" . session()->getFlashdata('message')."</div>";
                } ?>
                <div class="card card-default">
                    <div class="card-header">
                        <h3 class="card-title text-bold">Postes ouverts</h3>
                    </div>

                    <div class="card-body">
                        

                        <div class="row mt-3">
                            <?php

                            use CodeIgniter\View\Table;

                            $table = new Table();

                            $template = [
                                'table_open' => '<table class="table table-bordered" id="">',
                            ];
                            $table->setTemplate($template);
                            $table->setHeading(['#', 'POSTE', 'LOCALITE', 'PUBLICATION', 'DUREE','PLACE','ACTIONS']);

                            if (!empty($postes)) {
                                $i = 1;
                                foreach ($postes as $poste) {
                                    $table->addRow([
                                        $i,
                                        $poste->nom.", <b>".$types[$poste->type_id]."<b>",
                                        $poste->pays.", ".$poste->ville,
                                        $poste->date_publication." au ".$poste->date_fin_publication,
                                        $poste->date_debut." au ".$poste->date_fin,
                                        $poste->nbPlace,
                                        anchor($locale . "/volontaire/candidature/poste/" . $poste->id, "Postuler", [])
                                    ]);
                                    $i++;
                                }
                            }

                            echo $table->generate();

                            ?>
                        </div>

                    </div>
                </div>
            </div>

        </div>

        <?php echo form_close(); ?>

    </section>
</div>


<?= $this->endSection(); ?>