<?= $this->extend("layout/index"); ?>
<?= $this->section('content'); ?>

<div class="content-wrapper" style="min-height: 357.039px;">
    <section class="content">
        <?php if ($canApply) { ?>
            <?php echo form_open_multipart($locale . "/volontaire/candidature", null, ['poste_id' => $poste->id]); ?>
        <?php } ?>

        <div class="row" style="margin-top:10px">
            <div class="col-md-9">
                <h2 class="text-bold"><?= \auth()->user()->last_name . ", " . \auth()->user()->first_name ?></h2>
                <?php if (!empty(session()->getFlashdata('message'))) {
                    echo "<div class='row'>" . session()->getFlashdata('message')."</div>";
                }

                if (!$canApply && empty(session()->getFlashdata('message'))) {
                    echo "<div class='row'><alert class='ml-2 alert alert-danger'>Vous avez déjà soumis une candidature pour ce poste.</alert><div>";
                }
                
                ?>
                <div class="card card-default">
                    <div class="card-header">
                        <h3 class="card-title text-bold">Je veux transmettre ma candidature</h3>
                    </div>

                    <?php

                    use App\Traits\PosteTrait;
                    use App\Traits\PaysTrait;
                    ?>
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-3">
                                <label for="">Nom</label><br>
                                <?= $poste->nom ?>
                            </div>
                            <div class="col-md-3">
                                <label for="">Type</label><br>
                                <?= PosteTrait::types($poste->type_id) ?>
                            </div>
                            <div class="col-md-3">
                                <label for="">Places</label><br>
                                <?= $poste->nbPlace ?>
                            </div>
                            <div class="col-md-3">
                                <label for="">Date de publication</label><br>
                                <?= $poste->date_publication ?>
                            </div>
                            <div class="col-md-3">
                                <label for="">Date de fin de publication</label><br>
                                <?= $poste->date_fin_publication ?>
                            </div>

                            <div class="col-md-3">
                                <label for="">Début du contrat</label><br>
                                <?= $poste->date_debut ?>
                            </div>
                            <div class="col-md-3">
                                <label for="">Fin du contrat</label><br>
                                <?= $poste->date_fin ?>
                            </div>

                            <div class="col-md-3">
                                <label for="">Localité</label><br>
                                <?= PaysTrait::ArrayFormat($poste->pays_id) ?>
                            </div>
                            <div class="col-md-3">
                                <label for="">Ville</label><br>
                                <?= $poste->ville ?>
                            </div>

                            <div class="col-md-5">
                                <label for="">Description</label><br>
                                <?= $poste->description ?>
                            </div>
                            <div class="col-md-3">

                            </div>
                            <?php if ($canApply) { ?>
                                <div class="col-md-3">
                                    <?php
                                    echo form_submit("mysubmit", "Postuler", "class='btn btn-primary btn-sm btn-block mt-4'");
                                    ?>
                                </div>
                            <?php } ?>
                        </div>

                        <div class="row mt-3">

                        </div>

                    </div>
                </div>
            </div>

            <div class="col-md-3">

            </div>
        </div>
        <?php if ($canApply) { ?>
            <?php echo form_close(); ?>
        <?php } ?>
    </section>
</div>


<?= $this->endSection(); ?>