<?= $this->extend("layout/index"); ?>
<?= $this->section('content'); ?>

<div class="content-wrapper" style="min-height: 357.039px;">
    <section class="content">
        <h2 class="text-bold"><?= \auth()->user()->last_name . ", " . \auth()->user()->first_name ?></h2>

        <div class="row" style="margin-top:10px">

            <div class="col-md-9">
                <?php if (!empty(session()->getFlashdata('message'))) {
                    echo "<div class='row'>".session()->getFlashdata('message')."</div>";
                } ?>
                <div class="card card-default">
                    <div class="card-body">
                        <div class="card-header">
                            <h3 class="card-title text-bold">Les postes</h3>
                        </div>
                        <?php

                        use CodeIgniter\View\Table;

                        $table = new Table();

                        $template = [
                            'table_open' => '<table class="table table-bordered" id="">',
                        ];
                        $table->setTemplate($template);
                        $table->setHeading(['#', 'POSTE', 'LOCALITE', 'PUBLICATION', 'DUREE', 'CANDIDATURE', 'ACTIONS']);
                        if (!empty($postes)) {
                            $i = 1;
                            foreach ($postes as $poste) {
                                $table->addRow([
                                    $i,
                                    $poste->nom . ", <b>" . $types[$poste->type_id] . "<b>",
                                    $poste->pays . ", " . $poste->ville,
                                    $poste->date_publication . " au " . $poste->date_fin_publication,
                                    $poste->date_debut . " au " . $poste->date_fin,
                                    anchor($locale . "/poste/candidats/" . $poste->id, $poste->candidatures, ''),
                                    anchor($locale . "/poste/poste/" . $poste->id, "<i class='fa fa-eye'></i>", '') . anchor($locale . "/poste/delete/" . $poste->id, "<i class='fa fa-trash text-danger'></i>", 'text-danger')

                                ]);
                                $i++;
                            }
                        }
                        echo $table->generate();
                        ?>
                    </div>

                </div>
            </div>

            <div class="col-md-3">
                <?php echo anchor($locale . "/poste/poste", 'Ajouter', "class='btn btn-primary btn-sm mt-2'"); ?>
            </div>

    </section>
</div>

<?= $this->endSection(); ?>