<?= $this->extend("layout/index"); ?>
<?= $this->section('content'); ?>

<div class="content-wrapper" style="min-height: 357.039px;">
    <section class="content">
        <h2 class="text-bold"><?= \auth()->user()->last_name . ", " . \auth()->user()->first_name ?></h2>

        <div class="row" style="margin-top:10px">

            <div class="col-md-9">
                <?php if (!empty(session()->getFlashdata('message'))) {
                    echo "<div class='row'>".session()->getFlashdata('message')."</div>";
                } ?>
                <div class="card card-default">
                    <div class="card-body">
                        <?php

                        use CodeIgniter\View\Table;
                        use Modules\Poste\Libraries\Poste;
                        use App\Traits\DecisionTrait;

                        $table = new Table();

                        $template = [
                            'table_open' => '<table class="table table-bordered" id="">',
                        ];
                        $table->setTemplate($template);
                        $table->setHeading(['#', 'CANDIDAT', 'GENRE', 'NAISSANCE', 'PROFESSION', 'DOC-TELECHARGER', 'DECISION','ACTIONS']);
                        if (!empty($candidats)) {
                            $i = 1;
                            foreach ($candidats as $candidat) {
                                $fichiers = 
                                $table->addRow([
                                    $i,
                                    $candidat->titre .", ".$candidat->nom ." ".$candidat->prenom,
                                    $candidat->genre ,
                                    $candidat->birthDate,
                                    $candidat->profession,
                                    Poste::getDocuments($candidat->volontaire_id),
                                    "<span class='".DecisionTrait::colors($candidat->decision)."'>".$candidat->decision."</span>",
                                    $candidat->decision == "IN_PROCESS"?anchor($locale . "/poste/decision/ACCEPTED/" . $candidat->id, "<i class='fa fa-check text-success'></i>", "class='text-success' title='Accepter l-emploi '").' '.anchor($locale . "/poste/decision/REFUSED/" . $candidat->id, "<i class='bi bi-hand-thumbs-down text-danger'></i>", "class='text-danger' title='Refuser l-emploi'"):"-"

                                ]);
                                $i++;
                            }
                        }
                        echo $table->generate();
                        ?>
                    </div>

                </div>
            </div>

            <div class="col-md-3">
                <?php echo anchor($locale . "/poste/poste", 'Ajouter', "class='btn btn-primary btn-sm mt-2'"); ?>
            </div>

    </section>
</div>

<?= $this->endSection(); ?>