<?= $this->extend("layout/index"); ?>
<?= $this->section('content'); ?>

<div class="content-wrapper" style="min-height: 357.039px;">
    <section class="content">
        <h2 class="text-bold"><?= \auth()->user()->last_name . ", " . \auth()->user()->first_name ?></h2>

        <div class="row" style="margin-top:10px">

            <div class="col-md-9">
                <?php if (!empty(session()->getFlashdata('message'))) {
                    echo session()->getFlashdata('message');
                } ?>
                <?php
                $id = (string)$poste->id;
                echo form_open_multipart($locale . "/poste/save", [], ['id' => $id]); ?>

                <div class="card card-default">
                    <div class="card-header">
                        <h3 class="card-title text-bold">Ajouter un poste</h3>
                        <p class='text-bold float-right'><font color='red'>*</font> Champ est obligatoire</p>
                    </div>

                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-6">
                                <?= form_label("Domaine d'expertise <font color='red'>*</font>"); ?>
                                <?php
                                echo form_dropdown('type_id', $types, set_value('type_id', $poste->type_id), "class = 'form-control' id='type_id'");
                                ?>
                                <?= !empty(validation_show_error('type_id')) ? "<p class='text-danger'>" . validation_show_error('type_id') . "</p>" : "" ?>
                            </div>

                            <div class="col-md-6">
                                <?= form_label("Poste publié <font color='red'>*</font>"); ?>
                                <?php
                                $nom = [
                                    'type'  => 'text',
                                    'name'  => 'nom',
                                    'id'    => 'nom',
                                    'value' => set_value('nom', $poste->nom),
                                    'placeholder' => "Nom",
                                    'class' => 'form-control',
                                ];

                                echo form_input($nom);
                                ?>
                                <?= !empty(validation_show_error('nom')) ? "<p class='text-danger'>" . validation_show_error('nom') . "</p>" : "" ?>

                            </div>

                            <div class="col-md-6">
                                <?= form_label("Date de début <font color='red'>*</font>"); ?>
                                <?php $date = set_value('date_debut', $poste->date_debut) ?>
                                <div class="input-group date" id="date_debut" data-target-input="nearest">
                                    <?= form_input('date_debut', $date, "class='form-control datetimepicker-input', id='date_debut' placeholder='Date de début'") ?>
                                    <div class="input-group-append" data-target="#date_debut" data-toggle="datetimepicker">
                                        <div class="input-group-text"><i class="fa fa-calendar"></i></div>
                                    </div>
                                </div>
                                <?= !empty(validation_show_error('date_debut')) ? "<p class='text-danger'>" . validation_show_error('date_debut') . "</p>" : "" ?>
                            </div>

                            <div class="col-md-6">
                                <?= form_label("Date de fin <font color='red'>*</font>"); ?>
                                <?php $date = set_value('date_fin', $poste->date_fin) ?>
                                <div class="input-group date" id="date_fin" data-target-input="nearest">
                                    <?= form_input('date_fin', $date, "class='form-control datetimepicker-input', id='date_fin' placeholder='Pour'") ?>
                                    <div class="input-group-append" data-target="#date_fin" data-toggle="datetimepicker">
                                        <div class="input-group-text"><i class="fa fa-calendar"></i></div>
                                    </div>
                                </div>
                                <?= !empty(validation_show_error('date_fin')) ? "<p class='text-danger'>" . validation_show_error('date_fin') . "</p>" : "" ?>
                            </div>

                            <div class="col-md-6">
                                <?= form_label("Date fin de publication <font color='red'>*</font>"); ?>
                                <?php $date = set_value('date_fin_publication', $poste->date_fin_publication) ?>
                                <div class="input-group date" id="date_fin_publication" data-target-input="nearest">
                                    <?= form_input('date_fin_publication', $date, "class='form-control datetimepicker-input', id='date_fin_publication' placeholder='Pour'") ?>
                                    <div class="input-group-append" data-target="#date_fin_publication" data-toggle="datetimepicker">
                                        <div class="input-group-text"><i class="fa fa-calendar"></i></div>
                                    </div>
                                </div>
                                <?= !empty(validation_show_error('date_fin_publication')) ? "<p class='text-danger'>" . validation_show_error('date_fin_publication') . "</p>" : "" ?>
                            </div>

                            <div class="col-md-6">
                                <?= form_label("Nombre de place <font color='red'>*</font>"); ?>
                                <?php
                                $nbPlace = [
                                    'type'  => 'text',
                                    'name'  => 'nbPlace',
                                    'id'    => 'nbPlace',
                                    'value' => set_value('nbPlace', $poste->nbPlace),
                                    'placeholder' => "Nombre de place",
                                    'class' => 'form-control',
                                ];

                                echo form_input($nbPlace);
                                ?>
                                <?= !empty(validation_show_error('nbPlace')) ? "<p class='text-danger'>" . validation_show_error('nbPlace') . "</p>" : "" ?>
                            </div>

                            <div class="col-md-6">
                                <?= form_label("Pays <font color='red'>*</font>"); ?>
                                <?php
                                echo form_dropdown('pays_id', $pays, set_value('pays_id', $poste->pays_id), "class = 'form-control' id='pays_id'");
                                ?>
                                <?= !empty(validation_show_error('pays_id')) ? "<p class='text-danger'>" . validation_show_error('pays_id') . "</p>" : "" ?>

                            </div>

                            <div class="col-md-6">
                                <?= form_label("Ville <font color='red'>*</font>"); ?>
                                <?php
                                $ville = [
                                    'type'  => 'text',
                                    'name'  => 'ville',
                                    'id'    => 'ville',
                                    'value' => set_value('ville', $poste->ville),
                                    'placeholder' => "Ville",
                                    'class' => 'form-control',
                                ];

                                echo form_input($ville);
                                ?>
                                <?= !empty(validation_show_error('ville')) ? "<p class='text-danger'>" . validation_show_error('ville') . "</p>" : "" ?>
                            </div>

                            <div class="col-md-12">
                                <?= form_label("Description <font color='red'>*</font>"); ?>
                                <?php
                                $description = [
                                    'type'  => 'text',
                                    'name'  => 'description',
                                    'id'    => 'description',
                                    'placeholder'    => 'description',
                                    'class'    => 'form-control',
                                ];

                                echo form_textarea($description, set_value('description', $poste->description));
                                ?>
                                <?= !empty(validation_show_error('description')) ? "<p class='text-danger'>" . validation_show_error('description') . "</p>" : "" ?>

                            </div>



                        </div>
                    </div>
                    <div class="card-header">
                        <?php
                        echo form_submit("mysubmit", "Ajouter", "class='btn btn-primary btn-sm'");
                        echo anchor($locale . '/poste', 'Retour', 'class="btn btn-default btn-sm"');

                        ?>
                    </div>
                </div>

                <?php echo form_close(); ?>
            </div>

    </section>
</div>

<?= $this->endSection(); ?>