<?php

namespace App\Traits;

trait CommonTrait
{
    public static function yesno($descr = "Option", $key = 0): array|string
    {

        $options = [
            "" => $descr,
            1 => "Oui",
            2 => "Non",
        ];

        return $key > 0 ? $options[$key] : $options;
    }

    public static function estStaff($key = 0): array|string
    {

        $options = [
            "" => "Choix",
            "OUI" => "OUI",
            "NON" => "NON",
            "ANCIEN" => "ANCIEN",
        ];

        return $key > 0 ? $options[$key] : $options;
    }

    public static function organisations($key = 0): array|string
    {

        $options = [
            "" => "Choix",
            1 => "CROIX ROUGE DU BURUNDI",
            2 => "CROIX ROUGE DU RWANDA",
            3 => "CROIX ROUGE DU CONGO - KINSHASA",
            4 => "CROIX ROUGE DU CONGO - BRAZAVILLE",
            9 => "Indéfini",
        ];

        return $key > 0 ? $options[$key] : $options;
    }

    public static function contrats($key = 0): array|string
    {

        $options = [
            "" => "Choix",
            1 => "Employe",
            2 => "Prestaire",
            3 => "Detachement",
        ];

        return $key > 0 ? $options[$key] : $options;
    }

    public static function tailleChemise($key = 0): array|string
    {

        $options = [
            "" => "Choix",
            "XXS" => "XXS",
            "XS" => "XS",
            "S" => "S",
            "M" => "M",
            "L" => "L",
            "XL" => "XL",
            "XXL" => "XXL",
            "XXXL" => "XXXL",
        ];

        return $key > 0 ? $options[$key] : $options;
    }

    public static function emplacements($key = 0): array|string
    {

        $options = [
            "" => "Choix",
            "CHAMP" => "Champ",
            "SIEGE SOCIAL" => "Siege social",
        ];

        return $key > 0 ? $options[$key] : $options;
    }

    public static function devise(): array
    {

        return [
            "" => "Choix (Devise)",
            "BIF" => "BIF",
            "USD" => "USD",
            "EU" => "EU",
        ];
    }



    public static function genres($gen = NULL): array|string
    {

        $genres =  [
            "" => "Choix",
            "HOMME" => "HOMME",
            "FEMME" => "FEMME",
            "AUTRE" => "AUTRE",
            "NON SPECIFIE" => "NON SPECIFIE",
        ];

        return $gen != "" ? $genres[$gen] : $genres;
    }

    public static function status(): array
    {

        return [
            "" => "Choix (Statut)",
            "SINGLE" => "Celibataire",
            "MARIED" => "Mariee",
            "DIVORCED" => "Divorce",
            "VEUF" => "Veuf(ve)",
            "CONC" => "Concubinage/Union libre",
        ];
    }
}
