<?php

namespace Modules\Volontaire\Database\Migrations;

use CodeIgniter\Database\Migration;

class Candidatures extends Migration
{
    public function up()
    {
        $this->forge->addField([
            'id' => [
                'type'           => 'INT',
                'constraint'     => 5,
                'unsigned'       => true,
                'auto_increment' => true,
            ],
            'poste_id' => [
                'type'       => 'INT',
                'constraint' => '11',
                'default' => NULL,
            ],
            'volontaire_id' => [
                'type'       => 'INT',
                'constraint' => '11',
                'default' => NULL,
            ],            
            'decision' => [
                'type'       => 'VARCHAR',
                'constraint' => '100',
                'default' => NULL,
            ],
            'commentaire' => [
                'type'       => 'TEXT',
                'default' => NULL,
            ],            
            'created_at DATETIME default current_timestamp',
            'updated_at DATETIME default NULL',
            'deleted_at DATETIME default NULL',
        ]);
        $this->forge->addKey('id', true);
        $this->forge->createTable('pt_candidatures');
    }

    public function down()
    {
        $this->forge->dropTable('pt_candidatures');
    }
}
