<?php

namespace Modules\Volontaire\Database\Migrations;

use CodeIgniter\Database\Migration;

class Experience extends Migration
{
    public function up()
    {
        $this->forge->addField([
            'id' => [
                'type'           => 'INT',
                'constraint'     => 5,
                'unsigned'       => true,
                'auto_increment' => true,
            ],
            'type_id' => [
                'type'       => 'INT',
                'constraint' => '100',
                'default' => NULL,
            ],
            'employeur' => [
                'type'       => 'VARCHAR',
                'constraint' => '255',
                'default' => NULL,
            ],
            'departement' => [
                'type'       => 'VARCHAR',
                'constraint' => '255',
                'default' => NULL,
            ],
            'position' => [
                'type'       => 'VARCHAR',
                'constraint' => '255',
                'default' => NULL,
            ],
            'champ_travail' => [
                'type'       => 'VARCHAR',
                'constraint' => '255',
                'default' => NULL,
            ],
            'date_debut' => [
                'type'       => 'DATE',
                'default' => NULL,
            ],
            'date_fin' => [
                'type'       => 'DATE',
                'default' => NULL,
            ],
            'user_id' => [
                'type'       => 'INT',
                'constraint' => '100',
                'default' => NULL,
            ],
            'created_at DATETIME default current_timestamp',
            'updated_at DATETIME default NULL',
            'deleted_at DATETIME default NULL',
        ]);
        $this->forge->addKey('id', true);
        $this->forge->createTable('vt_experiences');
    }

    public function down()
    {
        $this->forge->dropTable('vt_experiences');
    }
}
