<?php

namespace Modules\Volontaire\Database\Migrations;

use CodeIgniter\Database\Migration;

class Etude extends Migration
{
    public function up()
    {
        $this->forge->addField([
            'id' => [
                'type'           => 'INT',
                'constraint'     => 5,
                'unsigned'       => true,
                'auto_increment' => true,
            ],
            'type_id' => [
                'type'       => 'INT',
                'constraint' => '100',
                'default' => NULL,
            ],
            'description_qualification' => [
                'type'       => 'VARCHAR',
                'constraint' => '255',
                'default' => NULL,
            ],
            'accent_degre' => [
                'type'       => 'VARCHAR',
                'constraint' => '255',
                'default' => NULL,
            ],
            'institution' => [
                'type'       => 'VARCHAR',
                'constraint' => '255',
                'default' => NULL,
            ],
            'ville_pays' => [
                'type'       => 'VARCHAR',
                'constraint' => '255',
                'default' => NULL,
            ],
            'date_debut' => [
                'type'       => 'DATE',
                'default' => NULL,
            ],
            'date_fin' => [
                'type'       => 'DATE',
                'default' => NULL,
            ],
            'informations_complementaire' => [
                'type'       => 'VARCHAR',
                'constraint' => '255',
                'default' => NULL,
            ],
            'user_id' => [
                'type'       => 'INT',
                'constraint' => '100',
                'default' => NULL,
            ],
            'created_at DATETIME default current_timestamp',
            'updated_at DATETIME default NULL',
            'deleted_at DATETIME default NULL',
        ]);
        $this->forge->addKey('id', true);
        $this->forge->createTable('vt_etudes');
    }

    public function down()
    {
        $this->forge->dropTable('vt_etudes');
    }
}
