<?php

namespace Modules\Volontaire\Database\Migrations;

use CodeIgniter\Database\Migration;

class Language extends Migration
{
    public function up()
    {
        $this->forge->addField([
            'id' => [
                'type'           => 'INT',
                'constraint'     => 5,
                'unsigned'       => true,
                'auto_increment' => true,
            ],
            'langue_id' => [
                'type'       => 'INI',
                'constraint' => '10',
            ],
            'niveau_ecrit' => [
                'type'       => 'VARCHAR',
                'constraint' => '10',
                'default' => NULL,
            ], 
            'niveau_lire' => [
                'type'       => 'VARCHAR',
                'constraint' => '10',
                'default' => NULL,
            ],
            'niveau_oral' => [
                'type'       => 'VARCHAR',
                'constraint' => '10',
                'default' => NULL,
            ],
            'user_id' => [
                'type'       => 'VARCHAR',
                'constraint' => '10',
                'default' => NULL,
            ],
            'created_at DATETIME default current_timestamp',
            'updated_at DATETIME default NULL',
            'deleted_at DATETIME default NULL',
        ]);
        $this->forge->addKey('id', true);
        $this->forge->createTable('vt_languages');
    }

    public function down()
    {
        $this->forge->dropTable('vt_languages');
    }
}
