<?php

namespace Modules\Volontaire\Database\Migrations;

use CodeIgniter\Database\Migration;

class Volontaire extends Migration
{
    public function up()
    {
        $this->forge->addField([
            'id' => [
                'type'           => 'INT',
                'constraint'     => 5,
                'unsigned'       => true,
                'auto_increment' => true,
            ],
            'nom' => [
                'type'       => 'VARCHAR',
                'constraint' => '100',
                'default'    => NULL
            ],
            'prenom' => [
                'type'       => 'VARCHAR',
                'constraint' => '100',
                'default'    => NULL
            ],
            'surnom' => [
                'type'       => 'VARCHAR',
                'constraint' => '100',
                'default'    => NULL
            ],
            'genre' => [
                'type'       => 'ENUM',
                'constraint' => ['HOMME', 'FEMME','AUTRE','NON SPECIFIE'],
                'default'    => 'NON SPECIFIE',
            ],
            'birthDate' => [
                'type'       => 'DATE',
                'default'    => NULL
            ],
            'paysEligibiliteId' => [
                'type'       => 'VARCHAR',
                'constraint' => '100',
                'default'    => NULL,
            ],
            'paysRefusId' => [
                'type'       => 'VARCHAR',
                'constraint' => '100',
                'default'    => NULL,
            ],
            'nationaliteId' => [
                'type'       => 'VARCHAR',
                'constraint' => '100',
                'default'    => NULL,
            ],
            'profession' => [
                'type'       => 'VARCHAR',
                'constraint' => '255',
                'default'    => NULL,
            ],
            'titre' => [
                'type'       => 'VARCHAR',
                'constraint' => '255',
                'default'    => NULL,
            ],
            'estStaff' => [
                'type'       => 'ENUM',
                'constraint' => ['OUI','NON','ANCIEN'],
                'default'    => 'NON',
            ],
            'organisationId' => [
                'type'       => 'INT',
                'constraint' => '11',
                'default'    => NULL,
            ],
            'emplacement' => [
                'type'       => 'ENUM',
                'constraint' => ['CHAMP','SIEGE SOCIAL'],
                'default'    => 'SIEGE SOCIAL',
            ],
            'numeroRH' => [
                'type'       => 'VARCHAR',
                'constraint' => '100',
                'default'    => NULL,
            ], 
            'contratId'=>[
                'type'       => 'INT',
                'constraint' => '11',
                'default'    => NULL
            ],          
            'passportImagePath' => [
                'type'       => 'VARCHAR',
                'constraint' => '100',
                'default' => NULL,
            ],            
            'userId' => [
                'type'       => 'INT',
                'default'    => NULL
            ],
            'tailleChemiseId' => [
                'type'       => 'ENUM',
                'constraint' => ['XXS','XS','S','M','L','XL','XXL','XXXL'],
                'default'    => 'S',
            ],
            'pointure' => [
                'type'       => 'VARCHAR',
                'constraint' => '100',
                'default' => NULL,
            ],
            'created_at DATETIME default current_timestamp',
            'updated_at DATETIME default NULL',
            'deleted_at DATETIME default NULL',
        ]);
        $this->forge->addKey('id', true);
        $this->forge->createTable('vt_volontaires');
    }

    public function down()
    {
        $this->forge->dropTable('vt_volontaires');        
    }
}
