<?php

namespace Modules\Volontaire\Controllers;

use App\Controllers\BaseController;
use App\ThirdParty\fpdf\PdfModel;
use App\Traits\CommonTrait;
use App\Traits\PaysTrait;

use CodeIgniter\HTTP\ResponseInterface;
use Modules\Administration\Models\User;
use Modules\Volontaire\Entities\Volontaire as EntitiesVolontaire;
use Modules\Volontaire\Models\Volontaire as ModelsVolontaire;
use UConverter;

class Volontaire extends BaseController
{
    // public function __construct()
    // {
    //     $session = session();        
    // }
    public function index()
    {
        $this->viewData['url_list'] = "";
        $this->viewData['js'] = "";

        $volontaire = (new ModelsVolontaire())->where('userId', \auth()->user()->id)->first();
        $this->viewData['volontaire'] = $volontaire;
        $this->viewData['genres'] = CommonTrait::genres();
        $this->viewData['estStaff'] = CommonTrait::estStaff();
        $this->viewData['organisations'] = CommonTrait::organisations();
        $this->viewData['pays'] = PaysTrait::ArrayFormat();
        $this->viewData['emplacements'] = CommonTrait::emplacements();
        $this->viewData['contrats'] = CommonTrait::contrats();
        $this->viewData['tailles'] = CommonTrait::tailleChemise();

        return view('volonatire/identite', $this->viewData);
    }

    function list()
    {
        $this->viewData['url_list'] = "";
        $this->viewData['js'] = "";
        $this->viewData['volontaires'] = (new ModelsVolontaire())->findAll();
        $this->viewData['organisations'] = CommonTrait::organisations();

        return view('volonatire/index', $this->viewData);
    }

    public function save()
    {

        $id = $this->request->getPost('id');

        if (! $this->validate($this->valideForm())) {
            $this->viewData['url_list'] = "";
            $this->viewData['js'] = "";

            $volontaire = (new ModelsVolontaire())->find($id);
            $this->viewData['volontaire'] = $volontaire;
            $this->viewData['genres'] = CommonTrait::genres();
            $this->viewData['estStaff'] = CommonTrait::estStaff();
            $this->viewData['organisations'] = CommonTrait::organisations();
            $this->viewData['pays'] = PaysTrait::ArrayFormat();
            $this->viewData['emplacements'] = CommonTrait::emplacements();
            $this->viewData['contrats'] = CommonTrait::contrats();
            $this->viewData['tailles'] = CommonTrait::tailleChemise();

            return view('volonatire/identite', $this->viewData);
        } else {
            $stmnt = (new ModelsVolontaire())->update($id, $this->volontaire());

            //Update user table
            $userId = \auth()->user()->id;
            $userData = [
                'first_name' => $this->request->getPost('nom'),
                'last_name' => $this->request->getPost('prenom'),
                'mobile_number' => $this->request->getPost('telephone')
            ];
            (new User())->update($userId, $userData);
            if ($stmnt) {
                $this->session->setFlashdata('message', "<alert class='ml-2 alert alert-success'>Vos informations de base ont mise a jour avec succès</alert>");
                return redirect()->to(site_url($this->viewData['locale'] . '/volontaire/identite'));
            }
        }
    }

    private function valideFormPhoto()
    {
        $rules = [];
        $rules['passportImagePath'] = [
            'uploaded[passportImagePath]',
            'max_size[passportImagePath,2024]',
            'is_image[passportImagePath]'
        ];

        return $rules;
    }

    public function photo()
    {
        $id = $this->request->getPost('id');

        if (!$this->validate($this->valideFormPhoto())) {
            $this->viewData['url_list'] = "";
            $this->viewData['js'] = "";

            $volontaire = (new ModelsVolontaire())->find($id);
            $this->viewData['volontaire'] = $volontaire;
            $this->viewData['genres'] = CommonTrait::genres();
            $this->viewData['estStaff'] = CommonTrait::estStaff();
            $this->viewData['organisations'] = CommonTrait::organisations();
            $this->viewData['pays'] = PaysTrait::ArrayFormat();
            $this->viewData['emplacements'] = CommonTrait::emplacements();
            $this->viewData['contrats'] = CommonTrait::contrats();
            $this->viewData['tailles'] = CommonTrait::tailleChemise();

            return view('volonatire/identite', $this->viewData);
        } else {

            $file = $this->request->getFile('passportImagePath');

            if ($file->isValid() && !$file->hasMoved()) {
                $newName = $id . "_" . $file->getRandomName();
                $file->move('uploads/passport/', $newName);

                $stmnt = (new ModelsVolontaire())->update($id, ['passportImagePath' => $newName]);
                if ($stmnt) {
                    $session = session();
                    $session->set('passportImage', $newName);

                    $this->session->setFlashdata('message', "<alert class='ml-2 alert alert-success'>Votre photo de profil a été chargée avec succès</alert>");
                    return redirect()->to(site_url($this->viewData['locale'] . '/volontaire/identite'));
                }
            }
        }
    }

    private function volontaire(): EntitiesVolontaire
    {
        $volontaire = new EntitiesVolontaire();

        $volontaire->nom = $this->request->getPost('nom');
        $volontaire->prenom = $this->request->getPost('prenom');
        $volontaire->surnom = $this->request->getPost('surnom');
        $volontaire->genre = $this->request->getPost('genre');
        $volontaire->email = $this->request->getPost('email');
        $volontaire->telephone = $this->request->getPost('telephone');
        $volontaire->birthDate = $this->request->getPost('birthDate');
        $volontaire->paysEligibiliteId = $this->request->getPost('paysEligibiliteId');
        $volontaire->profession = $this->request->getPost('profession');
        $volontaire->titre = $this->request->getPost('titre');
        $volontaire->estStaff = $this->request->getPost('estStaff');
        $volontaire->organisationId = $this->request->getPost('organisationId');
        $volontaire->emplacement = $this->request->getPost('emplacement');
        $volontaire->numeroRH = $this->request->getPost('numeroRH');
        $volontaire->contratId = $this->request->getPost('contratId');
        $volontaire->nationaliteId = $this->request->getPost('nationaliteId');
        $volontaire->tailleChemiseId = $this->request->getPost('tailleChemiseId');
        $volontaire->pointure = $this->request->getPost('pointure');
        $volontaire->userId = \auth()->user()->id;

        return $volontaire;
    }

    private function valideForm()
    {
        $rules = [];
        $rules['nom']      = ['rules'  => 'required|min_length[2]|max_length[100]'];
        $rules['prenom']     = ['rules'  => 'required|min_length[2]|max_length[100]'];
        // $rules['surnom']     = ['rules'  => 'required|min_length[2]|max_length[100]'];
        $rules['genre']     = ['rules'  => 'required|in_list[FEMME,HOMME,AUTRE,NON SPECIFIE]'];
        $rules['telephone']     = ['rules'  => 'required'];
        $rules['email']     = ['rules'  => 'required'];
        $rules['birthDate']     = ['rules'  => 'required'];
        // $rules['paysEligibiliteId']     = ['rules'  => 'required'];
        $rules['profession']     = ['rules'  => 'required'];
        // $rules['titre']     = ['rules'  => 'required'];
        $rules['estStaff']     = ['rules'  => 'required|in_list[OUI,NON,ANCIEN]'];
        $rules['organisationId']     = ['rules'  => 'required'];
        $rules['emplacement']     = ['rules'  => 'required|in_list[CHAMP,SIEGE SOCIAL]'];
        // $rules['numeroRH']     = ['rules'  => 'required'];
        // $rules['contratId']     = ['rules'  => 'required'];
        // $rules['emplacement']     = ['rules'  => 'required|in_list[CHAMP,SIEGE SOCIAL]'];
        $rules['nationaliteId']     = ['rules'  => 'required'];

        return $rules;
    }

    function pdf()
    {
        $pdf = new PdfModel();

        $volontaire = (new ModelsVolontaire())->where('userId', \auth()->user()->id)->first();

        $nom = isset($volontaire->nom) ? $volontaire->nom : "...";
        $prenom = isset($volontaire->prenom) ? $volontaire->prenom : "...";
        $nationaliteId = isset($volontaire->nationaliteId) ? $volontaire->nationaliteId : 1000;
        $surnom = isset($volontaire->surnom) ? $volontaire->surnom : "...";
        $genre = isset($volontaire->genre) ? $volontaire->genre : "...";

        $pdf->AliasNbPages();
        $pdf->SetAutoPageBreak(1, 13);
        $pdf->AddPage();
        $this->response->setHeader('Content-Type', 'application/pdf');
        $pdf->SetFont('Times', '', 10);
        $pdf->Cell(185, 3, $this->formatText("Généré, le ") . date('d/m/Y'), 0, 1, 'R');
        $pdf->SetFont('Times', 'B', 14);
        $pdf->Cell(185, 20, $this->formatText($nom . " " . $prenom . "(" . PaysTrait::ArrayFormat($nationaliteId) . ") - VOLONTAIRE"), "B", 1, 'C');
        $pdf->Ln(5);


        $pdf->SetFont('Times', 'B', 10);
        $pdf->Cell(40, 5, $this->formatText("Nom"), '', 0, 'L');
        $pdf->Cell(40, 5, $this->formatText("Prénoms "), '', 0, 'L');
        $pdf->Cell(64, 5, $this->formatText("Surnom"), '', 0, 'L');
        $pdf->Cell(40, 5, $this->formatText("Genre"), '', 1, 'L');

        $pdf->SetFont('Times', '', 10);
        $pdf->Cell(40, 5, $this->formatText($nom), '', 0, 'L');
        $pdf->Cell(40, 5, $this->formatText($prenom), '', 0, 'L');
        $pdf->Cell(64, 5, $this->formatText($surnom), '', 0, 'L');
        $pdf->Cell(40, 5, $this->formatText($genre), '', 1, 'L');
        $pdf->Ln(5);

        $pdf->SetFont('Times', 'B', 10);
        $pdf->Cell(40, 5, $this->formatText("Titre"), '', 0, 'L');
        $pdf->Cell(40, 5, $this->formatText("Téléphone"), '', 0, 'L');
        $pdf->Cell(64, 5, $this->formatText("E-mail"), '', 0, 'L');
        $pdf->Cell(40, 5, $this->formatText("Né(e) le"), '', 1, 'L');

        $titre = isset($volontaire->titre) ? $volontaire->titre : "...";
        $telephone = isset($volontaire->telephone) ? $volontaire->telephone : "...";
        $email = isset($volontaire->email) ? $volontaire->email : "...";
        $birthDate = isset($volontaire->birthDate) ? $volontaire->birthDate : "...";

        $pdf->SetFont('Times', '', 10);
        $pdf->Cell(40, 5, $this->formatText($titre), '', 0, 'L');
        $pdf->Cell(40, 5, $this->formatText($telephone), '', 0, 'L');
        $pdf->Cell(64, 5, $this->formatText($email), '', 0, 'L');
        $pdf->Cell(40, 5, $this->formatText($birthDate), '', 1, 'L');
        $pdf->Ln(5);

        $pdf->SetFont('Times', 'B', 10);
        $pdf->Cell(40, 5, $this->formatText("Profession"), '', 0, 'L');
        $pdf->Cell(40, 5, $this->formatText("Est staff de la NS?"), '', 0, 'L');
        $pdf->Cell(64, 5, $this->formatText("Organisation"), '', 0, 'L');
        $pdf->Cell(40, 5, $this->formatText("Emplacement"), '', 1, 'L');

        $profession = isset($volontaire->profession) ? $volontaire->profession : "...";
        $estStaff = isset($volontaire->estStaff) ? $volontaire->estStaff : "...";
        $organisationId = isset($volontaire->organisationId) ? $volontaire->organisationId : 9;
        $emplacement = isset($volontaire->emplacement) ? $volontaire->emplacement : "...";

        $pdf->SetFont('Times', '', 10);
        $pdf->Cell(40, 5, $this->formatText($profession), '', 0, 'L');
        $pdf->Cell(40, 5, $this->formatText($estStaff), '', 0, 'L');
        $pdf->Cell(64, 5, $this->formatText(CommonTrait::organisations($organisationId)), '', 0, 'L');
        $pdf->Cell(40, 5, $this->formatText($emplacement), '', 1, 'L');
        $pdf->Ln(5);

        $fileName = $this->formatText("identite/" . $nom . "_" . $prenom . ".pdf");
        $pdf->Output($fileName, 'F');
        $pdf->Output();
    }

    function formatText($string = NULL)
    {
        if (gettype($string) == "string") {
            $string = UConverter::transcode($string, 'ISO-8859-1', 'UTF8');
        }

        if (gettype($string) == "array") {
            foreach ($string as $key => $value) {
                $string[$key] = UConverter::transcode($value, 'ISO-8859-1', 'UTF8');
            }
        }

        return $string;
    }
}
