<?php

namespace Modules\Volontaire\Controllers;

use App\Controllers\BaseController;
use App\Traits\LanguageTrait;

use CodeIgniter\HTTP\ResponseInterface;
use Modules\Volontaire\Entities\Language as EntitiesLanguage;
use Modules\Volontaire\Models\Language as ModelsLanguage;

class Language extends BaseController
{
    public function index()
    {
        $this->viewData['url_list'] = "";
        $this->viewData['js'] = "";

        $languages = (new ModelsLanguage())->where('user_id', \auth()->user()->id)->findAll();
        $this->viewData['languages'] = $languages;
        $this->viewData['langues'] = LanguageTrait::langues();
        $this->viewData['niveaux'] = LanguageTrait::niveaux();

        return view('volonatire/language', $this->viewData);
    }

    public function save()
    {

        if (!$this->validate($this->valideForm())) {
            $this->viewData['url_list'] = "";
            $this->viewData['js'] = "";

            $languages = (new ModelsLanguage())->where('user_id', \auth()->user()->id)->findAll();
            $this->viewData['languages'] = $languages;
            $this->viewData['langues'] = LanguageTrait::langues();
            $this->viewData['niveaux'] = LanguageTrait::niveaux();

            return view('volonatire/language', $this->viewData);
        } else {
            $langue_id = $this->request->getPost('langue_id');
            $check_langue = (new ModelsLanguage())->asObject()->where(['langue_id'=>$langue_id,'user_id'=> \auth()->user()->id])->first();

            if(!empty($check_langue)){
                $stmnt = (new ModelsLanguage())->update($check_langue->id, $this->language());
            }else{
                $stmnt = (new ModelsLanguage())->save($this->language());
            }
            if ($stmnt) {
                $this->session->setFlashdata('message', "<alert class='ml-2 alert alert-success'>Compétence linguistique enregistrée avec succès</alert>");
                return redirect()->to(site_url($this->viewData['locale'] . '/volontaire/language'));
            }
        }
    }

    public function edit()
    {

        $id = $this->request->getPost('id');

        if (!$this->validate($this->valideForm())) {
            $this->viewData['url_list'] = "";
            $this->viewData['js'] = "";

            $languages = (new ModelsLanguage())->where('user_id', \auth()->user()->id)->findAll();
            $this->viewData['languages'] = $languages;
            $this->viewData['langues'] = LanguageTrait::langues();
            $this->viewData['niveaux'] = LanguageTrait::niveaux();

            return view('volonatire/language', $this->viewData);
        } else {

            $stmnt = (new ModelsLanguage())->update($id, $this->language());
            if ($stmnt) {
                $this->session->setFlashdata('message', "<alert class='ml-2 alert alert-success'>Compétence linguistique éditée avec succès</alert>");
                return redirect()->to(site_url($this->viewData['locale'] . '/volontaire/language'));
            }
        }
    }

    private function language()
    {
        $language = new EntitiesLanguage();

        $language->langue_id = $this->request->getPost('langue_id');
        $language->niveau_oral = $this->request->getPost('niveau_oral');
        $language->niveau_ecrit = $this->request->getPost('niveau_ecrit');
        $language->niveau_lire = $this->request->getPost('niveau_lire');
        $language->user_id = \auth()->user()->id;

        return $language;
    }

    private function valideForm()
    {
        $rules = [];
        $rules['langue_id']      = ['rules'  => 'required'];
        $rules['niveau_ecrit']     = ['rules'  => 'required'];
        $rules['niveau_lire']     = ['rules'  => 'required'];
        $rules['niveau_oral']     = ['rules'  => 'required'];

        return $rules;
    }

    function delete()
    {
        $uri = current_url(true);
        $id = $uri->getSegment(5);

        $stmnt = (new ModelsLanguage())->delete($id);

        if ($stmnt) {
            $this->session->setFlashdata('message', "<alert class='ml-2 alert alert-success'>Compétence linguistique est supprimée avec succès</alert>");
            return redirect()->to(site_url($this->viewData['locale'] . '/volontaire/language'));
        }
    }
}
