<?php

namespace Modules\Volontaire\Controllers;

use App\Controllers\BaseController;
use App\Traits\ExperienceTrait;

use CodeIgniter\HTTP\ResponseInterface;
use Modules\Volontaire\Entities\Experience as EntitiesExperience;
use Modules\Volontaire\Models\Experience as ModelsExperience;
use stdClass;

class Experience extends BaseController
{
    public function index()
    {
        $this->viewData['url_list'] = "";
        $this->viewData['js'] = "";

        $experiences = (new ModelsExperience())->where('user_id', \auth()->user()->id)->findAll();
        $this->viewData['experiences'] = $experiences;
        $this->viewData['types'] = ExperienceTrait::types();
        $this->viewData['positions'] = ExperienceTrait::positions();
        $this->viewData['domaines'] = ExperienceTrait::domaines();

        return view('volonatire/experience/index', $this->viewData); 
    }

    function add()
    {
        $uri = current_url(true);
        $id = $uri->getSegment(4);

        $experience = $id > 0 ?(new ModelsExperience())->find($id) : $this->stdClass();
        $this->viewData['url_list'] = "";
        $this->viewData['js'] = "";
        $this->viewData['experience'] = $experience;
        $this->viewData['types'] = ExperienceTrait::types();
        $this->viewData['positions'] = ExperienceTrait::positions();
        $this->viewData['domaines'] = ExperienceTrait::domaines();

        return view('volonatire/experience/add', $this->viewData);
    }


    public function save()
    {

        if (!$this->validate($this->valideForm())) {
            $id = $this->request->getPost('id');
            $experience = $id > 0 ?(new ModelsExperience())->find($id) : $this->stdClass();

            $this->viewData['url_list'] = "";
            $this->viewData['js'] = "";
            $this->viewData['types'] = ExperienceTrait::types();
            $this->viewData['positions'] = ExperienceTrait::positions();
            $this->viewData['domaines'] = ExperienceTrait::domaines();
            $this->viewData['experience'] = $experience;

            return view('volonatire/experience/add', $this->viewData);
        } else {
            $id = $this->request->getPost('id');

            if($id){
                $stmnt = (new ModelsExperience())->update($id, $this->experience());
            }else{
                $stmnt = (new ModelsExperience())->save($this->experience());
            }

            if ($stmnt) {
                $this->session->setFlashdata('message', "<alert class='ml-2 alert alert-success'>Expérience enregistrée avec succès</alert>");
                return redirect()->to(site_url($this->viewData['locale'] . '/volontaire/experiences'));
            }
        }
    }


    private function experience()
    {
        $experience = new EntitiesExperience();

        $experience->type_id = $this->request->getPost('type_id');
        $experience->employeur = $this->request->getPost('employeur');
        $experience->departement = $this->request->getPost('departement');
        $experience->position = $this->request->getPost('position');
        $experience->domaine = $this->request->getPost('domaine');
        $experience->responsabilite = $this->request->getPost('responsabilite');
        $experience->date_debut = $this->request->getPost('date_debut');
        $experience->date_fin = $this->request->getPost('date_fin');
        $experience->description = $this->request->getPost('description');
        $experience->user_id = \auth()->user()->id; 

        return $experience;
    }

    private function valideForm()
    {
        $rules = [];
        $rules['type_id']      = ['rules'  => 'required'];
        $rules['employeur']     = ['rules'  => 'required'];
        $rules['position']     = ['rules'  => 'required'];
        $rules['date_debut']     = ['rules'  => 'required'];
        $rules['responsabilite']     = ['rules'  => 'required'];
        $rules['domaine']     = ['rules'  => 'required'];

        return $rules;
    }

    function delete()
    {
        $uri = current_url(true);
        $id = $uri->getSegment(5);

        $stmnt = (new ModelsExperience())->delete($id);

        if ($stmnt) {
            $this->session->setFlashdata('message', "<alert class='ml-2 alert alert-success'>L'expérience est supprimée avec succès</alert>");
            return redirect()->to(site_url($this->viewData['locale'] . '/volontaire/experiences'));
        }
    }

    function stdClass(){
        $experience = new stdClass();
        $experience->id = 0;
        $experience->type_id = 0;
        $experience->employeur = "";
        $experience->position = "";
        $experience->domaine = "";
        $experience->responsabilite = "";
        $experience->description = "";
        $experience->date_debut = '';
        $experience->date_fin = '';

        return $experience;
    }
}
