<?php

namespace Modules\Volontaire\Controllers;

use App\Controllers\BaseController;
use App\Traits\EducationTrait;

use CodeIgniter\HTTP\ResponseInterface;
use Modules\Volontaire\Entities\Etude as EntitiesEtude;
use Modules\Volontaire\Models\Etude as ModelsEtude;

class Etude extends BaseController
{
    
    public function index()
    {
        $this->viewData['url_list'] = "";
        $this->viewData['js'] = "";

        $etudes = (new ModelsEtude())->where('user_id', \auth()->user()->id)->findAll();
        $this->viewData['etudes'] = $etudes;
        $this->viewData['types'] = EducationTrait::types();

        return view('volonatire/etude/index', $this->viewData);
    }

    function add(){
        $this->viewData['url_list'] = "";
        $this->viewData['js'] = "";
        $this->viewData['types'] = EducationTrait::types();

        return view('volonatire/etude/add', $this->viewData); 
    }

    
    public function save()
    {

        if (!$this->validate($this->valideForm())) {
            $this->viewData['url_list'] = "";
            $this->viewData['js'] = "";
            $this->viewData['types'] = EducationTrait::types();

        return view('volonatire/etude/add', $this->viewData); 
        } else {
           $stmnt = (new ModelsEtude())->save($this->etude());
            
            if ($stmnt) {
                $this->session->setFlashdata('message', "<alert class='ml-2 alert alert-success'>Niveau d'éducation supprimé avec succès</alert>");
                return redirect()->to(site_url($this->viewData['locale'] . '/volontaire/etudes'));
            }
        }
    }


    private function etude()
    {
        $etude = new EntitiesEtude();

        $etude->type_id = $this->request->getPost('type_id');
        $etude->description_qualification = $this->request->getPost('description_qualification');
        $etude->accent_degre = $this->request->getPost('accent_degre');
        $etude->institution = $this->request->getPost('institution');
        $etude->ville_pays = $this->request->getPost('ville_pays');
        $etude->date_debut = $this->request->getPost('date_debut');
        $etude->date_fin = $this->request->getPost('date_fin');
        $etude->informations_complementaire = $this->request->getPost('informations_complementaire');
        $etude->user_id = \auth()->user()->id;

        return $etude;
    }

    private function valideForm()
    {
        $rules = [];
        $rules['type_id']      = ['rules'  => 'required'];
        $rules['description_qualification']     = ['rules'  => 'required'];
        $rules['institution']     = ['rules'  => 'required'];
        $rules['accent_degre']     = ['rules'  => 'required'];
        $rules['date_debut']     = ['rules'  => 'required'];

        return $rules;
    }

    function delete()
    {
        $uri = current_url(true);
        $id = $uri->getSegment(5);

        $stmnt = (new ModelsEtude())->delete($id);

        if ($stmnt) {
            $this->session->setFlashdata('message', "<alert class='ml-2 alert alert-success'>Niveau d'éducation supprimé avec succès</alert>");
            return redirect()->to(site_url($this->viewData['locale'] . '/volontaire/etudes'));
        }
    }
}
