<?php

namespace Modules\Volontaire\Controllers;

use App\Controllers\BaseController;
use CodeIgniter\Database\RawSql;
use CodeIgniter\HTTP\ResponseInterface;
use Modules\Poste\Models\Poste;
use App\Traits\PosteTrait;
use Modules\Volontaire\Entities\Candidature as CandidatureEntity;
use Modules\Volontaire\Models\Candidature as ModelsCandidature;

class Candidature extends BaseController
{
    function index()
    {
        $this->viewData['url_list'] = "";
        $this->viewData['js'] = "";

        $uri = current_url(true);
        $posteId = $uri->getSegment(5);
        $this->viewData['poste'] = (new Poste())->find($posteId);
        $this->viewData['canApply'] = $this->verifyCandidature($posteId);

        return view('volonatire/candidature/index', $this->viewData);
    }

    public function postes()
    {
        $this->viewData['url_list'] = "";
        $this->viewData['js'] = "";

        $date_now = date('Y-m-d');
        $userId = \auth()->user()->id;
        $sql = "cd.poste_id = pt.id AND cd.volontaire_id != $userId";

        $db = \Config\Database::connect();
        $query   = $db->table('pt_postes pt');
        $query->select("pt.*, p.description AS pays");
        $query->join('pays p', 'p.id = pt.pays_id');
        $query->join('pt_candidatures cd', new RawSql($sql), 'LEFT');
        $query->where("pt.date_fin_publication >= '$date_now'");
        $postes = $query->get()->getResult();

        $this->viewData['postes'] = $postes;
        $this->viewData['types'] = PosteTrait::types();

        return view('volonatire/candidature/postes', $this->viewData);
    }

    public function applications()
    {
        $this->viewData['url_list'] = "";
        $this->viewData['js'] = "";

        $userId = \auth()->user()->id;
        $sql = "cd.poste_id = pt.id AND cd.volontaire_id = $userId";

        $db = \Config\Database::connect();
        $query   = $db->table('pt_postes pt');
        $query->select("pt.*, p.description AS pays, cd.decision, cd.id as candidature_id");
        $query->join('pays p', 'p.id = pt.pays_id');
        $query->join('pt_candidatures cd', new RawSql($sql), 'INNER');
        $postes = $query->get()->getResult();

        $this->viewData['postes'] = $postes;
        $this->viewData['types'] = PosteTrait::types();

        return view('volonatire/candidature/applications', $this->viewData);
    }

    function add()
    {
        $stmnt = (new ModelsCandidature())->save($this->candidature());

        if ($stmnt) {
            $posteId = $this->request->getPost('poste_id');
            $poste = (new Poste())->find($posteId);

            $posteDescr = $poste->nom . " " . PosteTrait::types($poste->type_id);
            $this->session->setFlashdata('message', "<alert class='ml-2 alert alert-success'>Votre candidature au poste <b>$posteDescr</b> a été enregistrée avec succès.</alert>");
            return redirect()->to(site_url($this->viewData['locale'] . "/volontaire/candidature/poste/" . $posteId));
        }
    }

    function candidature()
    {

        $candidature = new CandidatureEntity();
        $user = \auth()->user();

        $candidature->poste_id = $this->request->getPost('poste_id');
        $candidature->volontaire_id = $user->id;
        $candidature->decision = "IN_PROCESS";

        return $candidature;
    }

    function verifyCandidature($posteId)
    {
        $user = \auth()->user();
        $canditature = (new ModelsCandidature())->where(['poste_id' => $posteId, 'volontaire_id' => $user->id])->get()->getNumRows();
        return $canditature == 0 ? TRUE : FALSE;
    }
}
