<?php

namespace Modules\Poste\Controllers;

use App\Controllers\BaseController;
use App\Traits\PaysTrait;
use App\Traits\PosteTrait;
use CodeIgniter\Events\Events;
use CodeIgniter\HTTP\ResponseInterface;
use Modules\Poste\Entities\Poste as EntitiesPoste;
use Modules\Poste\Models\Poste as ModelsPoste;
use Modules\Volontaire\Models\Candidature as ModelsCandidature;
use stdClass;

class Poste extends BaseController
{
    public function index()
    {
        $this->viewData['url_list'] = "";
        $this->viewData['js'] = "";

        $db = \Config\Database::connect();
        $query   = $db->table('pt_postes pt');
        $query->select("pt.*, p.description AS pays, COUNT(cd.id) as candidatures");
        $query->join('pays p', 'p.id = pt.pays_id');
        $query->join('pt_candidatures cd', "cd.poste_id = pt.id", 'LEFT');
        $query->groupBy('pt.id');
        $postes = $query->get()->getResult();

        $this->viewData['postes'] = $postes;
        $this->viewData['pays'] = PaysTrait::ArrayFormat();
        $this->viewData['types'] = PosteTrait::types();

        return view('poste/poste/index', $this->viewData);
    }

    function candidats()
    {
        $uri = current_url(true);
        $posteId = $uri->getSegment(4);

        $db = \Config\Database::connect();
        $query   = $db->table('pt_candidatures cd');
        $query->select("cd.*, vl.titre ,vl.nom,vl.prenom, vl.genre, vl.birthDate,vl.profession");
        $query->join('vt_volontaires vl', "vl.id = cd.volontaire_id");
        $query->where("cd.poste_id", $posteId);
        $candidats = $query->get()->getResult();

        $this->viewData['candidats'] = $candidats;
        $this->viewData['url_list'] = "";
        $this->viewData['js'] = "";
        return view('poste/poste/candidats', $this->viewData);
    }

    function add()
    {
        $uri = current_url(true);
        $id = $uri->getSegment(4);
        $poste = $id > 0 ? (new ModelsPoste())->find($id) : $this->stdClass();

        $this->viewData['url_list'] = "";
        $this->viewData['js'] = "";
        $this->viewData['poste'] = $poste;
        $this->viewData['types'] = PosteTrait::types();
        $this->viewData['pays'] = PaysTrait::ArrayFormat();

        return view('poste/poste/add', $this->viewData);
    }

    public function save()
    {
        if (!$this->validate($this->valideForm())) {
            $id = $this->request->getPost('id');
            $poste = $id > 0 ? (new ModelsPoste())->find($id) : $this->stdClass();

            $this->viewData['url_list'] = "";
            $this->viewData['js'] = "";
            $this->viewData['types'] = PosteTrait::types();
            $this->viewData['poste'] = $poste;
            $this->viewData['pays'] = PaysTrait::ArrayFormat();

            return view('poste/poste/add', $this->viewData);
        } else {
            $id = $this->request->getPost('id');

            $posteModel = (new ModelsPoste());
            if ($id) {
                $stmnt = $posteModel->update($id, $this->poste());
            } else {
                $stmnt = $posteModel->save($this->poste());
                $id = $posteModel->getInsertID();

                Events::trigger('sendEmail', $id);

            }

            if ($stmnt) {
                $this->session->setFlashdata('message', "<alert class='ml-2 alert alert-success'>Poste <b>".$this->request->getPost('nom')."</b>enregistré avec succès</span>");
                return redirect()->to(site_url($this->viewData['locale'] . '/poste'));
            }
        }
    }


    private function poste()
    {
        $poste = new EntitiesPoste();

        $poste->nom = $this->request->getPost('nom');
        $poste->description = $this->request->getPost('description');
        $poste->date_debut = $this->request->getPost('date_debut');
        $poste->date_fin = $this->request->getPost('date_fin');
        $poste->date_fin_publication = $this->request->getPost('date_fin_publication');
        $poste->nbPlace = $this->request->getPost('nbPlace');
        $poste->pays_id = $this->request->getPost('pays_id');
        $poste->ville = $this->request->getPost('ville');
        $poste->type_id = $this->request->getPost('type_id');
        $poste->user_id = \auth()->user()->id;

        return $poste;
    }

    private function valideForm()
    {
        $rules = [];
        $rules['nom']      = ['rules'  => 'required'];
        $rules['date_debut']     = ['rules'  => 'required'];
        $rules['date_fin']     = ['rules'  => 'required'];
        $rules['date_fin_publication']     = ['rules'  => 'required'];
        $rules['nbPlace']     = ['rules'  => 'required'];
        $rules['pays_id']     = ['rules'  => 'required'];
        $rules['ville']     = ['rules'  => 'required'];
        $rules['type_id']     = ['rules'  => 'required'];
        $rules['description']     = ['rules'  => 'required'];

        return $rules;
    }

    function delete()
    {
        $uri = current_url(true);
        $id = $uri->getSegment(4);

        $stmnt = (new ModelsPoste())->delete($id);

        if ($stmnt) {
            $this->session->setFlashdata('message', "<alert class='ml-2 alert alert-success'>Poste est supprimé avec succès</alert>");
            return redirect()->to(site_url($this->viewData['locale'] . '/poste'));
        }
    }

    function decision()
    {
        $uri = current_url(true);
        $decision = $uri->getSegment(4);
        $id = $uri->getSegment(5);

        $stmnt = (new ModelsCandidature())->update($id, ['decision' => $decision]);

        if ($stmnt) {
            $this->session->setFlashdata('message', "<alert class='ml-2 alert alert-success'>Votre décision a été prise en considération.</alert>");
            return redirect()->back();
        }
    }

    function stdClass()
    {
        $poste = new stdClass();
        $poste->id = 0;
        $poste->nom = "";
        $poste->description = "";
        $poste->type_id = "";
        $poste->ville = "";
        $poste->pays_id = 0;
        $poste->nbPlace = 0;
        $poste->date_fin_publication = "";
        $poste->date_debut = '';
        $poste->date_fin = '';

        return $poste;
    }
}
