<?php

namespace Modules\Administration\Libraries;

class User
{

    public static function rules($id = NULL, $password = ""): array
    {
        $rules = [];

        if ($id > 0) {
            $rules['username'] = [
                'rules'  => "required|min_length[4]|max_length[50]|is_unique[users.username, id, {$id}]",
                'errors' => [
                    'is_unique' => lang("Administration.absence_form_is_unique"),
                ],
            ];
            if (!empty($password)) {
                $rules['password'] = ['rules'  => 'matches[confirm_password]'];
                $rules['confirm_password'] = ['rules'  => 'required|matches[password]'];
            }
        } else {
            $rules['username'] = ['rules'  => 'required|is_unique[users.username]'];
            $rules['email'] = ['rules'  => 'required|valid_email|is_unique[auth_identities.secret]'];
        }
        $rules['first_name'] = ['rules'  => 'required|min_length[2]|max_length[100]'];
        $rules['last_name'] = ['rules'  => 'required|min_length[2]|max_length[100]'];
        $rules['mobile_number'] = ['rules'  => 'required|min_length[2]|max_length[100]'];

        return $rules;
    }

    public static function tableRows($datas, $locale)
    {
        $i = 1;
        $array_data = array();
        if (!empty($datas)) {
            foreach ($datas as $data) {

                $sub_array = array();

                $sub_array[] =  $i;
                $sub_array = array();

                $sub_array[] =  $i;
                $sub_array[] =  $data->first_name;
                $sub_array[] =  $data->last_name;
                $sub_array[] =  $data->mobile_number;
                $sub_array[] =  $data->username;
                $sub_array[] =  $data->active == 0 ? lang("Params.yesno_n") : lang("Params.yesno_y");
                $sub_array[] =  implode(',', $data->getGroups());
                $option = "-";
                if (\auth()->user()->inGroup('admin') || \auth()->user()->hasPermission('admin.manage')) {
                    $option = anchor($locale . "/admin/user/" . $data->id, "<i class='fa fa-edit'></i>", ['class' => 'text-info']);
                }
                $sub_array[] = $option;

                $array_data[] = $sub_array;
                $i++;
            }
        }

        return  $array_data;
    }
}
