<?php

namespace Administratio\Config\Config;

// Create a new instance of our RouteCollection class.
$routes->group("{locale}/admin", ["namespace" => "\Modules\Administration\Controllers", 'filter' => ['appAuth', 'permission:admin.access']], function ($routes) {
    //Routes for users
    $routes->get("user", "User::index", ['filter' => 'permission:admin.manage']);
    $routes->post("user", "User::add", ['filter' => 'permission:admin.manage']);
    $routes->get("users", "User::get");
    $routes->post("users/data", "User::fecth");
    $routes->get("user/(:num)", "User::edit", ['filter' => 'permission:admin.manage']); 
    $routes->post("user/(:num)", "User::saveEdit", ['filter' => ['permission:admin.manage']]); 
    
    //Routes for groupes
    $routes->get("groupes", "Groupes::index");

    //Routes for permissions
    $routes->get("permissions", "Permissions::index");

});